/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.xml.bind.DatatypeConverter;
import org.jmxtrans.agent.AbstractOutputWriter;
import org.jmxtrans.agent.OutputWriter;
import org.jmxtrans.agent.util.ConfigurationUtils;
import org.jmxtrans.agent.util.StandardCharsets2;
import org.jmxtrans.agent.util.StringUtils2;

public class LibratoWriter
extends AbstractOutputWriter
implements OutputWriter {
    public static final String DEFAULT_LIBRATO_API_URL = "https://metrics-api.librato.com/v1/metrics";
    public static final String SETTING_USERNAME = "username";
    public static final String SETTING_TOKEN = "token";
    private String username;
    private String basicAuthentication;
    private String httpUserAgent;
    private URL url;
    private final AtomicInteger exceptionCounter = new AtomicInteger();

    @Override
    public synchronized void postConstruct(Map<String, String> settings) {
        String username = ConfigurationUtils.getString(settings, SETTING_USERNAME);
        String token = ConfigurationUtils.getString(settings, SETTING_TOKEN);
        if (username == null || token == null) {
            throw new RuntimeException("Username and/or token cannot be null");
        }
        this.username = username;
        this.basicAuthentication = DatatypeConverter.printBase64Binary((byte[])(username + ":" + token).getBytes(StandardCharsets2.US_ASCII));
        this.httpUserAgent = "jmxtrans-agent/2 (" + System.getProperty("java.vm.name") + "/" + System.getProperty("java.version") + "; " + System.getProperty("os.name") + "-" + System.getProperty("os.arch") + "/" + System.getProperty("os.version") + ")";
        try {
            this.url = new URL(DEFAULT_LIBRATO_API_URL);
        }
        catch (MalformedURLException e) {
            this.logger.info("Malformed url");
        }
        this.logger.info(String.format("LibratoWriter[username=%s, token=***]", username));
    }

    @Override
    public void postCollect() throws IOException {
    }

    @Override
    public void writeInvocationResult(String invocationName, Object value) throws IOException {
        this.writeQueryResult(invocationName, null, value);
    }

    @Override
    public synchronized void writeQueryResult(String metricName, String metricType, Object value) throws IOException {
        try {
            HttpURLConnection urlConnection = (HttpURLConnection)this.url.openConnection();
            urlConnection.setRequestMethod("POST");
            urlConnection.setDoInput(true);
            urlConnection.setDoOutput(true);
            urlConnection.setRequestProperty("content-type", "application/json; charset=utf-8");
            urlConnection.setRequestProperty("Authorization", "Basic " + this.basicAuthentication);
            urlConnection.setRequestProperty("User-Agent", this.httpUserAgent);
            OutputStreamWriter out = new OutputStreamWriter(urlConnection.getOutputStream(), StandardCharsets2.UTF_8);
            this.writeQueryResult(metricName, metricType, value, out);
            ((Writer)out).flush();
            ((Writer)out).close();
            int responseCode = urlConnection.getResponseCode();
            if (responseCode != 200) {
                this.exceptionCounter.incrementAndGet();
                this.logger.info(String.format("Failure %d:'%s' to send result to Librato server '%s', username %s", responseCode, urlConnection.getResponseMessage(), this.url, this.username));
            }
        }
        catch (RuntimeException e) {
            this.exceptionCounter.incrementAndGet();
            this.logger.info(String.format("Failure to send result to Librato server '%s' username %s", this.url, this.username));
        }
    }

    protected void writeQueryResult(String metricName, String metricType, Object value, Writer out) throws IOException {
        String libratoMetricsType = "gauge".equalsIgnoreCase(metricType) || "g".equalsIgnoreCase(metricType) ? "gauges" : "counters";
        out.write("{");
        out.write("\"" + libratoMetricsType + "\": [");
        out.write("{");
        out.write("\"name\": \"" + metricName + "\"");
        out.write(",");
        out.write("\"value\":");
        if (value == null) {
            out.write("null");
        } else if (value instanceof Number) {
            out.write(value.toString());
        } else if (value instanceof String) {
            out.write("\"" + ((String)value).replaceAll("\"", "\\\"") + "\"");
        } else {
            String valueAsString = value.toString();
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.warning("warning: no converter found for metric \"" + metricName + "\" with value type \"" + value.getClass() + "\". Use toString() on \"" + StringUtils2.abbreviate(valueAsString, 20) + "\"");
            }
            out.write(valueAsString);
        }
        out.write("}");
        out.write("]");
        out.write("}");
    }

    public int getExceptionCounter() {
        return this.exceptionCounter.get();
    }
}

