/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent.util.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import org.jmxtrans.agent.util.Preconditions2;
import org.jmxtrans.agent.util.io.AbstractResource;
import org.jmxtrans.agent.util.io.FileNotFoundRuntimeException;
import org.jmxtrans.agent.util.io.IoRuntimeException;
import org.jmxtrans.agent.util.io.IoUtils;
import org.jmxtrans.agent.util.io.Resource;
import org.jmxtrans.agent.util.logging.Logger;

public class UrlResource
extends AbstractResource
implements Resource {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    private final URL url;
    private final URI uri;

    public UrlResource(@Nonnull String url) {
        URI uri;
        Preconditions2.checkNotNull(url, "Given url cannot be null");
        try {
            this.url = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IoRuntimeException("Exception parsing URL '" + url + "'", e);
        }
        try {
            uri = this.url.toURI();
        }
        catch (URISyntaxException e) {
            throw new IoRuntimeException("Exception parsing URL '" + url + "'", e);
        }
        this.uri = uri;
    }

    @Override
    @Nonnull
    public File getFile() {
        if (IoUtils.isFileUrl(this.url)) {
            return new File(this.uri);
        }
        return super.getFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean exists() {
        if (IoUtils.isFileUrl(this.url)) {
            return super.exists();
        }
        try {
            URLConnection conn = this.url.openConnection();
            if (!(conn instanceof HttpURLConnection)) return super.exists();
            HttpURLConnection httpConn = (HttpURLConnection)conn;
            this.configureUrlConnection(httpConn);
            try {
                int responseCode = httpConn.getResponseCode();
                if (responseCode == 200) {
                    boolean bl = true;
                    return bl;
                }
                if (responseCode == 404) {
                    boolean bl = false;
                    return bl;
                }
                if (httpConn.getContentLength() > 0) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                httpConn.disconnect();
            }
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public long lastModified() {
        if (IoUtils.isFileUrl(this.url)) {
            return super.lastModified();
        }
        URLConnection conn = null;
        try {
            conn = this.url.openConnection();
            this.configureUrlConnection(conn);
            if (conn instanceof HttpURLConnection) {
                HttpURLConnection httpConn = (HttpURLConnection)conn;
                int responseCode = httpConn.getResponseCode();
                if (responseCode == 200) {
                    long l = httpConn.getLastModified();
                    return l;
                }
                if (responseCode == 404) {
                    throw new FileNotFoundRuntimeException(this.getDescription() + " not found: responseCode=" + responseCode + ", usingProxy=" + httpConn.usingProxy());
                }
                if (responseCode / 100 == 2 || responseCode / 100 == 3) {
                    long lastModified = httpConn.getLastModified();
                    if (this.logger.isLoggable(Level.FINER)) {
                        this.logger.finer(this.getDescription() + " returned an unexpected '" + responseCode + " " + httpConn.getResponseMessage() + "'. lastModified=" + lastModified);
                    }
                    long l = lastModified;
                    return l;
                }
                if (responseCode / 100 == 4) {
                    throw new IoRuntimeException(this.getDescription() + " is not accessible: responseCode=" + responseCode + ", usingProxy=" + httpConn.usingProxy());
                }
                if (responseCode / 100 == 5) {
                    throw new IoRuntimeException(this.getDescription() + " is not available: responseCode=" + responseCode + ", usingProxy=" + httpConn.usingProxy());
                }
                throw new IoRuntimeException(this.getDescription() + "returned an unexpected " + responseCode + " " + httpConn.getResponseMessage());
            }
            long httpConn = super.lastModified();
            return httpConn;
        }
        catch (IOException e) {
            throw IoRuntimeException.propagate(e);
        }
        finally {
            IoUtils.closeQuietly(conn);
        }
    }

    protected void configureUrlConnection(URLConnection conn) {
        if (conn instanceof HttpURLConnection) {
            HttpURLConnection httpConn = (HttpURLConnection)conn;
            int connectTimeoutInMillis = (int)TimeUnit.MILLISECONDS.convert(5L, TimeUnit.SECONDS);
            httpConn.setConnectTimeout(connectTimeoutInMillis);
            int readTimeoutInMillis = (int)TimeUnit.MILLISECONDS.convert(5L, TimeUnit.SECONDS);
            httpConn.setReadTimeout(readTimeoutInMillis);
        }
    }

    @Override
    @Nonnull
    public InputStream getInputStream() {
        URLConnection cnn = null;
        try {
            cnn = this.url.openConnection();
            this.configureUrlConnection(cnn);
            return cnn.getInputStream();
        }
        catch (IOException e) {
            IoUtils.closeQuietly(cnn);
            throw IoRuntimeException.propagate(e);
        }
    }

    @Override
    public String getDescription() {
        return "Http resource: " + this.url;
    }
}

