/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jmxtrans.agent.AbstractOutputWriter;
import org.jmxtrans.agent.OutputWriter;
import org.jmxtrans.agent.util.StringUtils2;

public class ConsoleOutputWriter
extends AbstractOutputWriter
implements OutputWriter {
    private String metricPathPrefix;

    @Override
    public void postConstruct(@Nonnull Map<String, String> settings) {
        this.metricPathPrefix = StringUtils2.trimToEmpty(settings.get("namePrefix"));
    }

    @Override
    public void writeQueryResult(@Nonnull String name, @Nullable String type, @Nullable Object value) {
        System.out.println(this.metricPathPrefix + name + " " + value + " " + TimeUnit.SECONDS.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS) + " " + type);
    }

    @Override
    public void writeInvocationResult(@Nonnull String invocationName, @Nullable Object value) throws IOException {
        System.out.println(this.metricPathPrefix + invocationName + " " + value + " " + TimeUnit.SECONDS.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS));
    }
}

