/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent.google;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.bind.DatatypeConverter;
import org.jmxtrans.agent.util.StringUtils2;
import org.jmxtrans.agent.util.json.Json;
import org.jmxtrans.agent.util.json.JsonObject;
import org.jmxtrans.agent.util.json.JsonValue;
import org.jmxtrans.agent.util.logging.Logger;

public class Connection {
    private static final String AUTH_URL = "https://accounts.google.com/o/oauth2/token";
    private static final String GRANT_TYPE = "urn:ietf:params:oauth:grant-type:jwt-bearer";
    private static final String SCOPE = "https://www.googleapis.com/auth/monitoring";
    private static final String API_URL = "https://monitoring.googleapis.com/v3";
    private static Logger logger = Logger.getLogger(Connection.class.getName());
    private Boolean useGkeServiceAccount = false;
    private String token;
    private Date expiry;
    private String serviceAccount = null;
    private PrivateKey privateKey = null;
    Object tokenLock = new Object();

    Connection(String serviceAccount, String serviceAccountKey, String credentialsFileLocation) {
        this.serviceAccount = serviceAccount;
        if (!StringUtils2.isNullOrEmpty(serviceAccount) && !StringUtils2.isNullOrEmpty(serviceAccountKey)) {
            logger.info("Metrics Service Account has been provided : " + serviceAccount);
            this.serviceAccount = serviceAccount;
            this.privateKey = this.getPrivateKeyFromString(serviceAccountKey);
        }
        if (this.privateKey == null && !StringUtils2.isNullOrEmpty(credentialsFileLocation)) {
            logger.info("Metrics Credentials File Name has been set explicitly : " + credentialsFileLocation);
            this.setFromFile(credentialsFileLocation);
        }
        if (this.privateKey == null && null != this.getGoogleApiTokenFromMetadataApi()) {
            logger.info("Google Container Engine Metadata API is available. Using 'default' cluster Service Account");
            this.useGkeServiceAccount = true;
            return;
        }
        String googleCredentialEnv = System.getenv("GOOGLE_APPLICATION_CREDENTIALS");
        if (this.privateKey == null && !StringUtils2.isNullOrEmpty(googleCredentialEnv)) {
            logger.info("No explicit Metrics connection configuration provided. Checking GOOGLE_APPLICATION_CREDENTIALS.");
            this.setFromFile(googleCredentialEnv);
        }
        if (this.privateKey == null) {
            throw new RuntimeException("Failed to initialise connection to GCP Monitoring");
        }
    }

    public String doGet(String urlString, String content) throws Exception {
        String token = this.getGoogleApiToken();
        return this.httpCall("https://monitoring.googleapis.com/v3/" + urlString, "GET", content, token);
    }

    public String doPost(String urlString, String content) throws Exception {
        String token = this.getGoogleApiToken();
        return this.httpCall("https://monitoring.googleapis.com/v3/" + urlString, "POST", content, token);
    }

    private void setFromFile(String credentialsFileLocation) {
        try {
            JsonObject object = Json.parse(new InputStreamReader((InputStream)new FileInputStream(credentialsFileLocation), "UTF-8")).asObject();
            this.serviceAccount = object.get("client_email").asString();
            this.privateKey = this.getPrivateKeyFromString(object.get("private_key").asString());
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Unable to parse '" + credentialsFileLocation + "' : " + e.getMessage(), e);
        }
    }

    private PrivateKey getPrivateKeyFromString(String serviceKeyPem) {
        if (StringUtils2.isNullOrEmpty(serviceKeyPem)) {
            return null;
        }
        PrivateKey privateKey = null;
        try {
            String privKeyPEM = serviceKeyPem.replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "").replace("\\r", "").replace("\\n", "").replace("\r", "").replace("\n", "");
            byte[] encoded = DatatypeConverter.parseBase64Binary((String)privKeyPEM);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encoded);
            privateKey = KeyFactory.getInstance("RSA").generatePrivate(keySpec);
        }
        catch (Exception e) {
            String error = "Constructing Private Key from PEM string failed: " + e.getMessage();
            logger.log(Level.SEVERE, error, e);
        }
        return privateKey;
    }

    private String getGoogleApiToken() {
        if (this.useGkeServiceAccount.booleanValue()) {
            return this.getGoogleApiTokenFromMetadataApi();
        }
        if (StringUtils2.isNullOrEmpty(this.token) || this.expiry == null || System.currentTimeMillis() + 30000L > this.expiry.getTime()) {
            this.prepareApiToken();
        }
        return this.token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getGoogleApiTokenFromMetadataApi() {
        BufferedReader in = null;
        try {
            URLConnection yc = new URL("http://metadata.google.internal/computeMetadata/v1/instance/service-accounts/default/token").openConnection();
            yc.setRequestProperty("Metadata-Flavor", "Google");
            in = new BufferedReader(new InputStreamReader(yc.getInputStream(), "UTF-8"));
            JsonObject json = Json.parse(in.readLine()).asObject();
            if (json != null && json.get("access_token") != null) {
                String string = json.get("access_token").asString();
                return string;
            }
            String string = null;
            return string;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to source Access Token from Metadata API : " + e.getMessage());
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareApiToken() {
        Object object = this.tokenLock;
        synchronized (object) {
            if (!StringUtils2.isNullOrEmpty(this.token) && this.expiry != null && System.currentTimeMillis() + 30000L <= this.expiry.getTime()) {
                return;
            }
            try {
                JsonValue errorDesc;
                JsonValue error;
                JsonObject header = new JsonObject();
                header.add("alg", "RS256");
                header.add("typ", "JWT");
                long utcSeconds = System.currentTimeMillis() / 1000L;
                JsonObject claim = new JsonObject();
                claim.add("aud", AUTH_URL);
                claim.add("exp", utcSeconds + 3600L);
                claim.add("iat", utcSeconds);
                claim.add("iss", this.serviceAccount);
                claim.add("scope", SCOPE);
                String payload = this.encodeBase64Url(header.toString().getBytes(Charset.forName("UTF-8"))) + "." + this.encodeBase64Url(claim.toString().getBytes(Charset.forName("UTF-8")));
                String assertion = payload + "." + this.encodeBase64Url(this.signSHA256withRSA(payload));
                LinkedHashMap<String, String> postParameters = new LinkedHashMap<String, String>();
                postParameters.put("grant_type", GRANT_TYPE);
                postParameters.put("assertion", assertion);
                String content = this.convertMapToContent(postParameters);
                String response = this.httpCall(AUTH_URL, "GET", content, null);
                String newToken = null;
                Date newExpiry = null;
                JsonObject json = Json.parse(response).asObject();
                if (json != null && json.get("access_token") != null) {
                    newToken = json.get("access_token").asString();
                    newExpiry = new Date(utcSeconds * 1000L + (long)(json.get("expires_in").asInt() * 1000));
                }
                if ((error = json.get("error")) != null) {
                    logger.log(Level.SEVERE, error.toString());
                }
                if ((errorDesc = json.get("error_description")) != null) {
                    logger.log(Level.SEVERE, errorDesc.toString());
                }
                if (!StringUtils2.isNullOrEmpty(newToken) && newExpiry != null && System.currentTimeMillis() < newExpiry.getTime()) {
                    this.token = newToken;
                    this.expiry = newExpiry;
                    logger.log(Level.FINE, "Token : " + this.token);
                    logger.fine("Refreshed token. New expiry instant : " + this.expiry);
                } else {
                    logger.log(Level.WARNING, "Token refresh failed. Token : " + this.token + " Expiry : " + this.expiry);
                }
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Token refresh failed " + ex.getMessage(), ex);
            }
        }
    }

    private byte[] signSHA256withRSA(String value) {
        byte[] result = null;
        try {
            Signature signature = Signature.getInstance("SHA256withRSA");
            signature.initSign(this.privateKey);
            signature.update(value.getBytes(Charset.forName("UTF-8")));
            result = signature.sign();
        }
        catch (Exception var7) {
            logger.log(Level.SEVERE, var7.getMessage(), var7);
        }
        return result;
    }

    private String encodeBase64Url(byte[] value) {
        if (value == null) {
            return null;
        }
        if (value.length == 0) {
            return "";
        }
        try {
            String encoded = DatatypeConverter.printBase64Binary((byte[])value).replace("=", "").replace("+", "-").replace("/", "_");
            return encoded;
        }
        catch (Exception var4) {
            logger.log(Level.WARNING, "FAILED URL ENCODING " + var4.getMessage(), var4);
            return null;
        }
    }

    private String convertMapToContent(LinkedHashMap<String, String> postParameters) throws Exception {
        StringBuilder content = new StringBuilder("");
        for (Map.Entry<String, String> entry : postParameters.entrySet()) {
            content.append((content.length() > 0 ? "&" : "") + URLEncoder.encode(entry.getKey(), "UTF-8") + "=" + (!StringUtils2.isNullOrEmpty(entry.getValue()) ? URLEncoder.encode(entry.getValue(), "UTF-8") : ""));
        }
        return content.length() > 0 ? content.toString() : null;
    }

    private String httpCall(String urlString, String method, String content, String token) throws Exception {
        String line;
        InputStream is;
        StringBuilder result = new StringBuilder();
        URL url = new URL(urlString);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("User-Agent", "jmxtrans-agent");
        conn.setRequestProperty("Authorization", "Bearer " + token);
        conn.setRequestMethod(method.toUpperCase());
        if (method.equalsIgnoreCase("POST")) {
            conn.setRequestProperty("Content-Type", "application/json");
        }
        if (!StringUtils2.isNullOrEmpty(content)) {
            conn.setDoOutput(true);
        }
        conn.setDoInput(true);
        conn.setUseCaches(false);
        conn.setAllowUserInteraction(false);
        conn.setRequestProperty("Connection", "Keep-Alive");
        conn.setRequestProperty("Content-length", StringUtils2.isNullOrEmpty(content) ? "0" : "" + content.length());
        conn.connect();
        if (!StringUtils2.isNullOrEmpty(content)) {
            OutputStream output = conn.getOutputStream();
            output.write(content.getBytes(Charset.forName("UTF-8")));
            output.flush();
        }
        boolean isError = false;
        if (conn.getResponseCode() < 400) {
            is = conn.getInputStream();
        } else {
            is = conn.getErrorStream();
            isError = true;
        }
        BufferedReader rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        while ((line = rd.readLine()) != null) {
            result.append(line);
        }
        rd.close();
        if (isError) {
            throw new RuntimeException(result.toString());
        }
        return result.toString();
    }
}

