/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent;

import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import org.jmxtrans.agent.Collector;
import org.jmxtrans.agent.OutputWriter;

public class TimeTrackingCollector {
    private Collector collector;
    private long lastRun = Long.MIN_VALUE;
    private long collectIntervalMillis;

    private static long currentMillis() {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
    }

    public TimeTrackingCollector(Collector collector, long collectIntervalMillis) {
        this.collector = collector;
        this.collectIntervalMillis = collectIntervalMillis;
    }

    public void collectIfEnoughTimeHasPassed(MBeanServer mbeanServer, OutputWriter outputWriter) {
        long currentMillis = TimeTrackingCollector.currentMillis();
        if (currentMillis >= this.lastRun + this.collectIntervalMillis) {
            this.lastRun = currentMillis;
            this.collector.collectAndExport(mbeanServer, outputWriter);
        }
    }

    public long getCollectIntervalMillis() {
        return this.collectIntervalMillis;
    }
}

