/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jmxtrans.agent.AbstractOutputWriter;
import org.jmxtrans.agent.OutputWriter;
import org.jmxtrans.agent.graphite.GraphiteMetricMessageBuilder;
import org.jmxtrans.agent.graphite.GraphiteOutputWriterCommonSettings;
import org.jmxtrans.agent.util.ConfigurationUtils;
import org.jmxtrans.agent.util.io.IoUtils;
import org.jmxtrans.agent.util.net.HostAndPort;

public class GraphitePlainTextTcpOutputWriter
extends AbstractOutputWriter
implements OutputWriter {
    public static final String SETTING_SOCKET_CONNECT_TIMEOUT_IN_MILLIS = "socket.connectTimeoutInMillis";
    public static final int SETTING_SOCKET_CONNECT_TIMEOUT_IN_MILLIS_DEFAULT_VALUE = 500;
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    protected HostAndPort graphiteServerHostAndPort;
    private Socket socket;
    private Writer writer;
    private int socketConnectTimeoutInMillis = 500;
    private GraphiteMetricMessageBuilder messageBuilder;

    @Override
    public void postConstruct(Map<String, String> settings) {
        super.postConstruct(settings);
        this.graphiteServerHostAndPort = new HostAndPort(ConfigurationUtils.getString(settings, "host"), ConfigurationUtils.getInt(settings, "port", 2003));
        this.messageBuilder = new GraphiteMetricMessageBuilder(GraphiteOutputWriterCommonSettings.getConfiguredMetricPrefixOrNull(settings));
        this.socketConnectTimeoutInMillis = ConfigurationUtils.getInt(settings, SETTING_SOCKET_CONNECT_TIMEOUT_IN_MILLIS, 500);
        this.logger.log(this.getInfoLevel(), "GraphitePlainTextTcpOutputWriter is configured with " + this.graphiteServerHostAndPort + ", metricPathPrefix=" + this.messageBuilder.getPrefix() + ", socketConnectTimeoutInMillis=" + this.socketConnectTimeoutInMillis);
    }

    @Override
    public void writeInvocationResult(@Nonnull String invocationName, @Nullable Object value) throws IOException {
        this.writeQueryResult(invocationName, null, value);
    }

    @Override
    public void writeQueryResult(@Nonnull String metricName, @Nullable String type, @Nullable Object value) throws IOException {
        String msg = this.messageBuilder.buildMessage(metricName, value, TimeUnit.SECONDS.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS));
        try {
            this.ensureGraphiteConnection();
            if (this.logger.isLoggable(this.getTraceLevel())) {
                this.logger.log(this.getTraceLevel(), "Send '" + msg + "' to " + this.graphiteServerHostAndPort);
            }
            this.writer.write(msg + "\n");
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "Exception sending '" + msg + "' to " + this.graphiteServerHostAndPort, e);
            this.releaseGraphiteConnection();
            throw e;
        }
    }

    private void releaseGraphiteConnection() {
        IoUtils.closeQuietly(this.writer);
        IoUtils.closeQuietly(this.socket);
    }

    private void ensureGraphiteConnection() throws IOException {
        boolean socketIsValid;
        try {
            socketIsValid = this.socket != null && this.socket.isConnected() && this.socket.isBound() && !this.socket.isClosed() && !this.socket.isInputShutdown() && !this.socket.isOutputShutdown();
        }
        catch (Exception e) {
            socketIsValid = false;
        }
        if (!socketIsValid) {
            this.writer = null;
            try {
                this.socket = new Socket();
                this.socket.setKeepAlive(true);
                this.socket.connect(new InetSocketAddress(this.graphiteServerHostAndPort.getHost(), this.graphiteServerHostAndPort.getPort()), this.socketConnectTimeoutInMillis);
            }
            catch (IOException e) {
                ConnectException ce = new ConnectException("Exception connecting to " + this.graphiteServerHostAndPort);
                ce.initCause(e);
                throw ce;
            }
        }
        if (this.writer == null) {
            this.writer = new OutputStreamWriter(this.socket.getOutputStream(), UTF_8);
        }
    }

    @Override
    public void postCollect() throws IOException {
        if (this.writer == null) {
            return;
        }
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "Exception flushing the stream to " + this.graphiteServerHostAndPort, e);
            this.releaseGraphiteConnection();
            throw e;
        }
    }

    public String toString() {
        return "GraphitePlainTextTcpOutputWriter{, " + this.graphiteServerHostAndPort + ", metricPathPrefix='" + this.messageBuilder.getPrefix() + '\'' + '}';
    }

    @Override
    public void preDestroy() {
        super.preDestroy();
        this.releaseGraphiteConnection();
    }

    String getMetricPathPrefix() {
        return this.messageBuilder.getPrefix();
    }
}

