/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent;

import java.lang.management.ManagementFactory;
import java.sql.Timestamp;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.management.MBeanServer;
import org.jmxtrans.agent.Invocation;
import org.jmxtrans.agent.JmxTransConfigurationLoader;
import org.jmxtrans.agent.JmxTransExporterConfiguration;
import org.jmxtrans.agent.OutputWriter;
import org.jmxtrans.agent.Query;
import org.jmxtrans.agent.util.logging.Logger;

public class JmxTransExporter {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private ThreadFactory threadFactory = new ThreadFactory(){
        final AtomicInteger counter = new AtomicInteger();

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = Executors.defaultThreadFactory().newThread(r);
            thread.setDaemon(true);
            thread.setName("jmxtrans-agent-" + this.counter.incrementAndGet());
            return thread;
        }
    };
    private ScheduledExecutorService scheduledExecutorService;
    private MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
    private ScheduledFuture scheduledFuture;
    private JmxTransConfigurationLoader configLoader;
    private JmxTransExporterConfiguration config;

    public JmxTransExporter(JmxTransConfigurationLoader configLoader) {
        this.configLoader = configLoader;
        this.config = configLoader.loadConfiguration();
    }

    public void start() {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.fine("starting " + this.toString() + " ...");
        } else {
            this.logger.fine("starting " + this.getClass().getName() + " ...");
        }
        if (this.scheduledExecutorService != null || this.scheduledFuture != null) {
            throw new IllegalArgumentException("Exporter is already started: scheduledExecutorService=" + this.scheduledExecutorService + ", scheduledFuture=" + this.scheduledFuture);
        }
        this.scheduledExecutorService = Executors.newScheduledThreadPool(1, this.threadFactory);
        if (this.config.getResultNameStrategy() == null) {
            throw new IllegalStateException("resultNameStrategy is not defined, jmxTransExporter is not properly initialised");
        }
        this.scheduledFuture = this.scheduledExecutorService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                JmxTransExporter.this.collectAndExport();
            }
        }, this.config.getCollectInterval() / 2, this.config.getCollectInterval(), this.config.getCollectIntervalTimeUnit());
        if (this.config.getConfigReloadInterval() >= 0) {
            Runnable runnable = new Runnable(){
                private final Logger logger = Logger.getLogger(JmxTransExporter.class.getName() + ".reloader");
                private long lastModified = JmxTransExporter.access$000(JmxTransExporter.this).lastModified();

                @Override
                public void run() {
                    long newLastModified = JmxTransExporter.this.configLoader.lastModified();
                    if (newLastModified == 0L) {
                        if (this.logger.isLoggable(Level.FINER)) {
                            this.logger.finer("Don't reload lastModified=" + this.lastModified + " / " + new Timestamp(this.lastModified) + ", newLastModified=" + newLastModified);
                        }
                    } else if (newLastModified > this.lastModified) {
                        this.logger.info("jmxtrans-agent configuration has changed. Reload " + JmxTransExporter.this.configLoader);
                        if (this.logger.isLoggable(Level.FINER)) {
                            this.logger.finer("Reload lastModified=" + this.lastModified + " / " + new Timestamp(this.lastModified) + ", newLastModified=" + newLastModified + " / " + new Timestamp(newLastModified));
                        }
                        this.lastModified = newLastModified;
                        JmxTransExporter.this.stop();
                        JmxTransExporter.this.config = JmxTransExporter.this.configLoader.loadConfiguration();
                        JmxTransExporter.this.start();
                    } else if (this.logger.isLoggable(Level.FINER)) {
                        this.logger.finer("Don't reload lastModified=" + this.lastModified + " / " + new Timestamp(this.lastModified) + ", newLastModified=" + newLastModified + " / " + new Timestamp(newLastModified));
                    }
                }
            };
            int configReloadIntervalInSecs = Math.max(this.config.getConfigReloadInterval(), 5);
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.info("Configuration reload interval: " + configReloadIntervalInSecs + "secs");
            }
            this.scheduledExecutorService.scheduleWithFixedDelay(runnable, 0L, configReloadIntervalInSecs, TimeUnit.SECONDS);
        }
        this.logger.fine(this.getClass().getName() + " started");
    }

    public void stop() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
            this.scheduledFuture = null;
        }
        this.scheduledExecutorService.shutdown();
        this.collectAndExport();
        try {
            this.scheduledExecutorService.awaitTermination(this.config.getCollectInterval(), this.config.getCollectIntervalTimeUnit());
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        this.scheduledExecutorService = null;
        this.config.getOutputWriter().preDestroy();
        this.logger.info(this.getClass().getName() + " stopped.");
    }

    protected void collectAndExport() {
        OutputWriter outputWriter = this.config.getOutputWriter();
        try {
            outputWriter.preCollect();
            for (Invocation invocation : this.config.getInvocations()) {
                try {
                    invocation.invoke(this.mbeanServer, outputWriter);
                }
                catch (Exception e) {
                    this.logger.log(Level.WARNING, "Ignore exception invoking " + invocation, e);
                }
            }
            for (Query query : this.config.getQueries()) {
                try {
                    query.collectAndExport(this.mbeanServer, outputWriter);
                }
                catch (Exception e) {
                    this.logger.log(Level.WARNING, "Ignore exception collecting metrics for " + query, e);
                }
            }
            outputWriter.postCollect();
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Ignore exception flushing metrics ", e);
        }
    }

    public String toString() {
        return "JmxTransExporter{, configuration=" + this.config + '}';
    }

    public void reloadConfiguration(JmxTransExporterConfiguration newConfiguration) {
        this.stop();
        this.config = newConfiguration;
        this.start();
    }
}

