/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jmxtrans.agent.AbstractOutputWriter;
import org.jmxtrans.agent.util.ConfigurationUtils;
import org.jmxtrans.agent.util.io.IoUtils;

public class RollingFileOutputWriter
extends AbstractOutputWriter {
    public static final String SETTING_FILE_NAME = "fileName";
    public static final String SETTING_FILE_NAME_DEFAULT_VALUE = "jmxtrans-agent.data";
    public static final String SETTING_MAX_FILE_SIZE = "maxFileSize";
    public static final long SETTING_MAX_FILE_SIZE_DEFAULT_VALUE = 10L;
    public static final String SETTING_MAX_BACKUP_INDEX = "maxBackupIndex";
    public static final int SETTING_MAX_BACKUP_INDEX_DEFAULT_VALUE = 5;
    private static DateFormat dfISO8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
    protected Writer temporaryFileWriter;
    protected File temporaryFile;
    protected File file = new File("jmxtrans-agent.data");
    protected long maxFileSize;
    protected int maxBackupIndex;

    @Override
    public synchronized void postConstruct(Map<String, String> settings) {
        super.postConstruct(settings);
        TimeZone tz = TimeZone.getTimeZone("UTC");
        dfISO8601.setTimeZone(tz);
        this.file = new File(ConfigurationUtils.getString(settings, SETTING_FILE_NAME, SETTING_FILE_NAME_DEFAULT_VALUE));
        this.maxFileSize = ConfigurationUtils.getLong(settings, SETTING_MAX_FILE_SIZE, 10L);
        this.maxBackupIndex = ConfigurationUtils.getInt(settings, SETTING_MAX_BACKUP_INDEX, 5);
        if (this.maxFileSize > 10L || this.maxFileSize < 0L) {
            this.maxFileSize = 10L;
        }
        this.maxFileSize *= 1000000L;
        this.logger.log(this.getInfoLevel(), "RollingFileOutputWriter configured with file " + this.file.getAbsolutePath());
    }

    protected Writer getTemporaryFileWriter() throws IOException {
        if (this.temporaryFile == null) {
            this.temporaryFile = File.createTempFile("jmxtrans-agent-", ".data");
            this.temporaryFile.deleteOnExit();
            if (this.logger.isLoggable(this.getDebugLevel())) {
                this.logger.log(this.getDebugLevel(), "Created temporary file " + this.temporaryFile.getAbsolutePath());
            }
            this.temporaryFileWriter = null;
        }
        if (this.temporaryFileWriter == null) {
            this.temporaryFileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.temporaryFile, false), StandardCharsets.UTF_8));
        }
        return this.temporaryFileWriter;
    }

    @Override
    public void writeInvocationResult(String invocationName, Object value) throws IOException {
        this.writeQueryResult(invocationName, null, value);
    }

    @Override
    public synchronized void writeQueryResult(@Nonnull String name, @Nullable String type, @Nullable Object value) throws IOException {
        try {
            this.getTemporaryFileWriter().write("[" + dfISO8601.format(Calendar.getInstance().getTime()) + "] " + name + " " + value + "\n");
        }
        catch (IOException e) {
            this.releaseTemporaryWriter();
            throw e;
        }
    }

    protected void releaseTemporaryWriter() {
        boolean deleted;
        try {
            IoUtils.closeQuietly(this.getTemporaryFileWriter());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.temporaryFile != null && !(deleted = this.temporaryFile.delete())) {
            this.logger.warning("Silently ignore failure to delete " + this.temporaryFile);
        }
        this.temporaryFile = null;
    }

    @Override
    public synchronized void postCollect() throws IOException {
        try {
            this.getTemporaryFileWriter().close();
            if (this.logger.isLoggable(this.getDebugLevel())) {
                this.logger.log(this.getDebugLevel(), "Overwrite " + this.file.getAbsolutePath() + " by " + this.temporaryFile.getAbsolutePath());
            }
            IoUtils.appendToFile(this.temporaryFile, this.file, this.maxFileSize, this.maxBackupIndex);
        }
        finally {
            this.temporaryFileWriter = null;
        }
    }
}

