/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent.graphite;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.annotation.Nullable;

public class GraphiteMetricMessageBuilder {
    private static final String DEFAULT_METRIC_PATH_PREFIX_FORMAT = "servers.%s.";
    private final String metricPathPrefix;

    public GraphiteMetricMessageBuilder(@Nullable String configuredMetricPathPrefix) {
        this.metricPathPrefix = GraphiteMetricMessageBuilder.buildMetricPathPrefix(configuredMetricPathPrefix);
    }

    public String buildMessage(String metricName, Object value, long timestamp) {
        return this.metricPathPrefix + metricName + " " + value + " " + timestamp;
    }

    private static String buildMetricPathPrefix(String configuredMetricPathPrefix) {
        String hostname;
        if (configuredMetricPathPrefix != null) {
            return configuredMetricPathPrefix;
        }
        try {
            hostname = InetAddress.getLocalHost().getHostName().replaceAll("\\.", "_");
        }
        catch (UnknownHostException e) {
            hostname = "#unknown#";
        }
        return String.format(DEFAULT_METRIC_PATH_PREFIX_FORMAT, hostname);
    }

    public String getPrefix() {
        return this.metricPathPrefix;
    }
}

