/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent.util;

import java.util.Map;

public class ConfigurationUtils {
    private ConfigurationUtils() {
    }

    public static int getInt(Map<String, String> settings, String name) throws IllegalArgumentException {
        String value = ConfigurationUtils.getString(settings, name);
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Setting '" + name + "=" + value + "' is not an integer on " + settings);
        }
    }

    public static int getInt(Map<String, String> settings, String name, int defaultValue) throws IllegalArgumentException {
        if (settings.containsKey(name)) {
            String value = settings.get(name).toString();
            try {
                return Integer.parseInt(value);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Setting '" + name + "=" + value + "' is not an integer on " + settings);
            }
        }
        return defaultValue;
    }

    public static long getLong(Map<String, String> settings, String name, long defaultValue) throws IllegalArgumentException {
        if (settings.containsKey(name)) {
            String value = settings.get(name).toString();
            try {
                return Long.parseLong(value);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Setting '" + name + "=" + value + "' is not a long on " + settings);
            }
        }
        return defaultValue;
    }

    public static boolean getBoolean(Map<String, String> settings, String name, boolean defaultValue) {
        if (settings.containsKey(name)) {
            String value = settings.get(name).toString();
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    public static String getString(Map<String, String> settings, String name) throws IllegalArgumentException {
        if (!settings.containsKey(name)) {
            throw new IllegalArgumentException("No setting '" + name + "' found");
        }
        return settings.get(name).toString();
    }

    public static String getString(Map<String, String> settings, String name, String defaultValue) {
        if (settings.containsKey(name)) {
            return settings.get(name).toString();
        }
        return defaultValue;
    }
}

