/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent.util.collect;

import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.Nonnull;
import org.jmxtrans.agent.util.collect.ForwardingQueue;

public class EvictingQueue<E>
extends ForwardingQueue<E>
implements Queue<E> {
    private LinkedBlockingQueue delegate;
    private int maxRetry = 10;

    public EvictingQueue(int capacity) {
        this.delegate = new LinkedBlockingQueue(capacity);
    }

    public static <E> EvictingQueue<E> create(int maxCapacity) {
        return new EvictingQueue<E>(maxCapacity);
    }

    @Override
    @Nonnull
    protected Queue<E> delegate() {
        return this.delegate;
    }

    @Override
    public boolean add(E e) {
        return this.addEvictingIfNeeded(e);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.standardAddAll(c);
    }

    @Override
    public boolean offer(E e) {
        return this.addEvictingIfNeeded(e);
    }

    protected boolean addEvictingIfNeeded(E e) {
        for (int i = 0; i < this.maxRetry; ++i) {
            boolean offered = this.delegate().offer(e);
            if (offered) {
                return true;
            }
            this.delegate().poll();
        }
        return false;
    }
}

