/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent.util.io;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.Timestamp;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jmxtrans.agent.util.io.IoRuntimeException;
import org.jmxtrans.agent.util.logging.Logger;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class IoUtils {
    protected static final Logger logger = Logger.getLogger(IoUtils.class.getName());

    public static long getFileLastModificationDate(@Nullable String filePath) throws IoRuntimeException {
        File file;
        if (filePath == null) {
            return 0L;
        }
        if (filePath.toLowerCase().startsWith("classpath:")) {
            File configurationFile;
            String classpathResourcePath = filePath.substring("classpath:".length());
            URL configurationFileUrl = Thread.currentThread().getContextClassLoader().getResource(classpathResourcePath);
            if (configurationFileUrl == null) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.fine("File '" + filePath + "' not found in classpath");
                }
                return 0L;
            }
            try {
                configurationFile = new File(configurationFileUrl.toURI());
            }
            catch (URISyntaxException e) {
                throw new IoRuntimeException("Exception parsing '" + filePath + "'", e);
            }
            if (!configurationFile.exists()) {
                throw new IllegalStateException("File path=" + filePath + ", url=" + configurationFileUrl + " not found");
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.fine("Classpath file '" + filePath + "' last modified at " + new Timestamp(configurationFile.lastModified()));
            }
            return configurationFile.lastModified();
        }
        if (filePath.toLowerCase().startsWith("http://") || filePath.toLowerCase().startsWith("https://")) {
            if (logger.isLoggable(Level.FINER)) {
                logger.fine("Http files not supported: '" + filePath + "' is seen as never modified");
            }
            return 0L;
        }
        if (filePath.toLowerCase().startsWith("file://")) {
            File file2;
            try {
                file2 = new File(new URI(filePath));
            }
            catch (RuntimeException | URISyntaxException e) {
                throw new IoRuntimeException("Exception parsing '" + filePath + "'", e);
            }
            if (file2.exists()) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.fine("File '" + filePath + "' last modified at " + new Timestamp(file2.lastModified()));
                }
                return file2.lastModified();
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.fine("File '" + filePath + "' not found ");
            }
            return 0L;
        }
        try {
            file = new File(filePath);
        }
        catch (RuntimeException e) {
            throw new IoRuntimeException("Exception parsing '" + filePath + "'", e);
        }
        if (file.exists()) {
            if (logger.isLoggable(Level.FINER)) {
                logger.fine("File '" + filePath + "' last modified at " + new Timestamp(file.lastModified()));
            }
            return file.lastModified();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.fine("File '" + filePath + "' not found ");
        }
        return 0L;
    }

    @Nonnull
    public static Document getFileAsDocument(@Nonnull String configurationFilePath) throws IoRuntimeException {
        if (configurationFilePath == null) {
            throw new IoRuntimeException(new NullPointerException("configurationFilePath cannot be null"));
        }
        try {
            DocumentBuilder dBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            if (configurationFilePath.toLowerCase().startsWith("classpath:")) {
                String classpathResourcePath = configurationFilePath.substring("classpath:".length());
                InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(classpathResourcePath);
                return dBuilder.parse(in);
            }
            if (configurationFilePath.toLowerCase().startsWith("file://") || configurationFilePath.toLowerCase().startsWith("http://") || configurationFilePath.toLowerCase().startsWith("https://")) {
                URL url = new URL(configurationFilePath);
                return dBuilder.parse(url.openStream());
            }
            File xmlFile = new File(configurationFilePath);
            if (!xmlFile.exists()) {
                throw new IllegalArgumentException("Configuration file '" + xmlFile.getAbsolutePath() + "' not found");
            }
            return dBuilder.parse(xmlFile);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new IoRuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doCopySmallFile(File source, File destination) throws IOException {
        if (destination.exists() && destination.isDirectory()) {
            throw new IOException("Can not copy file, destination is a directory: " + destination.getAbsolutePath());
        }
        FileInputStream fis = null;
        FileOutputStream fos = null;
        FileChannel input = null;
        FileChannel output = null;
        try {
            fis = new FileInputStream(source);
            fos = new FileOutputStream(destination, false);
            input = fis.getChannel();
            output = fos.getChannel();
            output.transferFrom(input, 0L, input.size());
        }
        catch (Throwable throwable) {
            IoUtils.closeQuietly(output);
            IoUtils.closeQuietly(input);
            IoUtils.closeQuietly(fis);
            IoUtils.closeQuietly(fos);
            throw throwable;
        }
        IoUtils.closeQuietly(output);
        IoUtils.closeQuietly(input);
        IoUtils.closeQuietly(fis);
        IoUtils.closeQuietly(fos);
        if (destination.length() != source.length()) {
            throw new IOException("Failed to copy content from '" + source + "' (" + source.length() + "bytes) to '" + destination + "' (" + destination.length() + ")");
        }
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void closeQuietly(Writer writer) {
        if (writer == null) {
            return;
        }
        try {
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void closeQuietly(InputStream inputStream) {
        if (inputStream == null) {
            return;
        }
        try {
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void replaceFile(File source, File destination) throws IOException {
        boolean deleted;
        boolean destinationExists = destination.exists() ? !(deleted = destination.delete()) : false;
        if (destinationExists) {
            IoUtils.doCopySmallFile(source, destination);
        } else {
            boolean renamed = source.renameTo(destination);
            if (!renamed) {
                IoUtils.doCopySmallFile(source, destination);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doCopySmallFile(File source, File destination, boolean append) throws IOException {
        boolean renamed;
        if (destination.exists() && destination.isDirectory()) {
            throw new IOException("Can not copy file, destination is a directory: " + destination.getAbsolutePath());
        }
        if (!destination.exists() && (renamed = source.renameTo(destination))) {
            return;
        }
        InputStream fis = null;
        FileOutputStream fos = null;
        Closeable input = null;
        Closeable output = null;
        long initialSize = destination.length();
        try {
            fos = new FileOutputStream(destination, append);
            if (append) {
                fos.write("\n".getBytes(StandardCharsets.UTF_8));
            }
            fos.write(Files.readAllBytes(Paths.get(source.getAbsolutePath(), new String[0])));
        }
        finally {
            IoUtils.closeQuietly(output);
            IoUtils.closeQuietly(input);
            IoUtils.closeQuietly(fis);
            IoUtils.closeQuietly(fos);
        }
        if (!append && destination.length() != source.length()) {
            throw new IOException("Failed to copy content from '" + source + "' (" + source.length() + "bytes) to '" + destination + "' (" + destination.length() + "). isAppend? " + append);
        }
        if (append && destination.length() <= initialSize) {
            throw new IOException("Failed to append content from '" + source + "' (" + source.length() + "bytes) to '" + destination + "' (" + destination.length() + "). isAppend? " + append);
        }
    }

    public static void appendToFile(File source, File destination, long maxFileSize, int maxBackupIndex) throws IOException {
        boolean destinationExists = IoUtils.validateDestinationFile(source, destination, maxFileSize, maxBackupIndex);
        if (destinationExists) {
            IoUtils.doCopySmallFile(source, destination, true);
        } else {
            boolean renamed = source.renameTo(destination);
            if (!renamed) {
                IoUtils.doCopySmallFile(source, destination, false);
            }
        }
    }

    public static boolean validateDestinationFile(File source, File destination, long maxFileSize, int maxBackupIndex) throws IOException {
        if (!destination.exists() || destination.isDirectory()) {
            return false;
        }
        long totalLengthAfterAppending = destination.length() + source.length();
        if (totalLengthAfterAppending > maxFileSize) {
            IoUtils.rollFiles(destination, maxBackupIndex);
            return false;
        }
        return true;
    }

    public static void rollFiles(File destination, int maxBackupIndex) throws IOException {
        for (int i = maxBackupIndex - 1; i >= 0; --i) {
            String path = destination.getAbsolutePath();
            path = i == 0 ? path : path + "." + i;
            File f = new File(path);
            if (!f.exists()) continue;
            File fNext = new File(destination + "." + (i + 1));
            IoUtils.doCopySmallFile(f, fNext, false);
        }
        boolean deleted = destination.delete();
        if (!deleted) {
            logger.warning("Failure to delete file " + destination);
        }
    }
}

