/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jmxtrans.agent.AbstractOutputWriter;
import org.jmxtrans.agent.util.ConfigurationUtils;
import org.jmxtrans.agent.util.io.IoUtils;

public class FileOverwriterOutputWriter
extends AbstractOutputWriter {
    public static final String SETTING_FILE_NAME = "fileName";
    public static final String SETTING_FILE_NAME_DEFAULT_VALUE = "jmxtrans-agent.data";
    public static final String SETTING_SHOW_TIMESTAMP = "showTimeStamp";
    public static final Boolean SETTING_SHOW_TIMESTAMP_DEFAULT = false;
    protected Writer temporaryFileWriter;
    protected File temporaryFile;
    protected File file = new File("jmxtrans-agent.data");
    protected Boolean showTimeStamp;
    private static Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
    private static DateFormat dfISO8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");

    @Override
    public synchronized void postConstruct(Map<String, String> settings) {
        super.postConstruct(settings);
        dfISO8601.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.file = new File(ConfigurationUtils.getString(settings, SETTING_FILE_NAME, SETTING_FILE_NAME_DEFAULT_VALUE));
        this.showTimeStamp = ConfigurationUtils.getBoolean(settings, SETTING_SHOW_TIMESTAMP, SETTING_SHOW_TIMESTAMP_DEFAULT);
        this.logger.log(this.getInfoLevel(), "FileOverwriterOutputWriter configured with file " + this.file.getAbsolutePath());
    }

    protected Writer getTemporaryFileWriter() throws IOException {
        if (this.temporaryFile == null) {
            this.temporaryFile = File.createTempFile("jmxtrans-agent-", ".data");
            this.temporaryFile.deleteOnExit();
            if (this.logger.isLoggable(this.getDebugLevel())) {
                this.logger.log(this.getDebugLevel(), "Created temporary file " + this.temporaryFile.getAbsolutePath());
            }
            this.temporaryFileWriter = null;
        }
        if (this.temporaryFileWriter == null) {
            this.temporaryFileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.temporaryFile, false), StandardCharsets.UTF_8));
        }
        return this.temporaryFileWriter;
    }

    @Override
    public void writeInvocationResult(String invocationName, Object value) throws IOException {
        this.writeQueryResult(invocationName, null, value);
    }

    @Override
    public synchronized void writeQueryResult(@Nonnull String name, @Nullable String type, @Nullable Object value) throws IOException {
        try {
            if (this.showTimeStamp.booleanValue()) {
                this.getTemporaryFileWriter().write("[" + dfISO8601.format(Calendar.getInstance().getTime()) + "] " + name + " " + value + "\n");
            } else {
                this.getTemporaryFileWriter().write(name + " " + value + "\n");
            }
        }
        catch (IOException e) {
            this.releaseTemporaryWriter();
            throw e;
        }
    }

    protected void releaseTemporaryWriter() {
        boolean deleted;
        try {
            IoUtils.closeQuietly(this.getTemporaryFileWriter());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.temporaryFile != null && (deleted = this.temporaryFile.delete())) {
            this.logger.warning("Failure to delete " + this.temporaryFile);
        }
        this.temporaryFile = null;
    }

    @Override
    public synchronized void postCollect() throws IOException {
        try {
            this.getTemporaryFileWriter().close();
            if (this.logger.isLoggable(this.getDebugLevel())) {
                this.logger.log(this.getDebugLevel(), "Overwrite " + this.file.getAbsolutePath() + " by " + this.temporaryFile.getAbsolutePath());
            }
            IoUtils.replaceFile(this.temporaryFile, this.file);
        }
        finally {
            this.temporaryFileWriter = null;
        }
    }
}

