/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jmxtrans.agent.DevNullOutputWriter;
import org.jmxtrans.agent.Invocation;
import org.jmxtrans.agent.OutputWriter;
import org.jmxtrans.agent.Query;
import org.jmxtrans.agent.ResultNameStrategy;
import org.w3c.dom.Document;

public class JmxTransExporterConfiguration {
    protected List<Query> queries = new ArrayList<Query>();
    protected List<Invocation> invocations = new ArrayList<Invocation>();
    protected OutputWriter outputWriter = new DevNullOutputWriter();
    protected ResultNameStrategy resultNameStrategy;
    protected int collectInterval = 10;
    protected TimeUnit collectIntervalTimeUnit = TimeUnit.SECONDS;
    private int configReloadInterval = -1;
    private Document document;

    public JmxTransExporterConfiguration(Document document) {
        this.document = document;
    }

    public JmxTransExporterConfiguration withQuery(@Nonnull String objectName, @Nonnull List<String> attributes, @Nullable String resultAlias) {
        return this.withQuery(objectName, attributes, null, null, null, resultAlias, null);
    }

    public JmxTransExporterConfiguration withQuery(@Nonnull String objectName, @Nonnull List<String> attributes, @Nullable String key, @Nullable Integer position, @Nullable String type, @Nullable String resultAlias, @Nullable Integer collectInterval) {
        Query query = new Query(objectName, attributes, key, position, type, resultAlias, this.resultNameStrategy, collectInterval);
        this.queries.add(query);
        return this;
    }

    public JmxTransExporterConfiguration withInvocation(@Nonnull String objectName, @Nonnull String operation, @Nullable String resultAlias, @Nullable Integer collectInterval) {
        this.invocations.add(new Invocation(objectName, operation, new Object[0], new String[0], resultAlias, collectInterval));
        return this;
    }

    public JmxTransExporterConfiguration withOutputWriter(OutputWriter outputWriter) {
        this.outputWriter = outputWriter;
        return this;
    }

    public JmxTransExporterConfiguration withCollectInterval(int collectInterval, @Nonnull TimeUnit collectIntervalTimeUnit) {
        this.collectInterval = collectInterval;
        this.collectIntervalTimeUnit = collectIntervalTimeUnit;
        return this;
    }

    public JmxTransExporterConfiguration withConfigReloadInterval(int configReloadInterval) {
        if (configReloadInterval < 0) {
            throw new IllegalArgumentException("configReloadInterval must be >= 0, was: " + configReloadInterval);
        }
        this.configReloadInterval = configReloadInterval;
        return this;
    }

    public List<Query> getQueries() {
        return this.queries;
    }

    public List<Invocation> getInvocations() {
        return this.invocations;
    }

    public OutputWriter getOutputWriter() {
        return this.outputWriter;
    }

    public ResultNameStrategy getResultNameStrategy() {
        return this.resultNameStrategy;
    }

    public int getCollectInterval() {
        return this.collectInterval;
    }

    public TimeUnit getCollectIntervalTimeUnit() {
        return this.collectIntervalTimeUnit;
    }

    public String toString() {
        return "JmxTransExporterConfiguration{queries=" + this.queries + ", invocations=" + this.invocations + ", outputWriter=" + this.outputWriter + ", collectInterval=" + this.collectInterval + " " + (Object)((Object)this.collectIntervalTimeUnit) + '}';
    }

    public Integer getConfigReloadInterval() {
        return this.configReloadInterval;
    }

    public Document getDocument() {
        return this.document;
    }

    public void destroy() {
        this.getOutputWriter().preDestroy();
    }
}

