/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent.util.io;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import javax.annotation.Nonnull;
import org.jmxtrans.agent.util.io.AbstractResource;
import org.jmxtrans.agent.util.io.FileNotFoundRuntimeException;
import org.jmxtrans.agent.util.io.Resource;

public class ClasspathResource
extends AbstractResource
implements Resource {
    private final String path;
    private final transient ClassLoader classLoader = Thread.currentThread().getContextClassLoader();

    public ClasspathResource(@Nonnull String path) {
        if (path.startsWith("classpath://")) {
            path = path.substring("classpath://".length());
        } else if (path.startsWith("classpath")) {
            path = path.substring("classpath:".length());
        }
        this.path = path;
    }

    @Override
    public boolean exists() {
        return this.classLoader.getResource(this.path) != null;
    }

    @Override
    @Nonnull
    public URL getURL() {
        return this.classLoader.getResource(this.path);
    }

    @Override
    @Nonnull
    public File getFile() {
        return new File(this.getURI());
    }

    @Override
    @Nonnull
    public InputStream getInputStream() {
        InputStream resourceAsStream = this.classLoader.getResourceAsStream(this.path);
        if (resourceAsStream == null) {
            throw new FileNotFoundRuntimeException(this.toString());
        }
        return resourceAsStream;
    }

    @Override
    public String getDescription() {
        return "Classpath resource: " + this.path;
    }
}

