/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.jmxtrans.agent.AbstractOutputWriter;
import org.jmxtrans.agent.graphite.GraphiteMetricMessageBuilder;
import org.jmxtrans.agent.graphite.GraphiteOutputWriterCommonSettings;
import org.jmxtrans.agent.util.net.HostAndPort;
import org.jmxtrans.agent.util.time.Clock;
import org.jmxtrans.agent.util.time.SystemCurrentTimeMillisClock;

public class GraphiteUdpOutputWriter
extends AbstractOutputWriter {
    static final Charset CHARSET_FOR_UDP_PACKET = Charset.forName("UTF-8");
    private HostAndPort graphiteServerHostAndPort;
    private UdpMessageSender messageSender;
    private Clock clock;
    private GraphiteMetricMessageBuilder messageBuilder;

    @Override
    public void postConstruct(Map<String, String> settings) {
        super.postConstruct(settings);
        this.graphiteServerHostAndPort = GraphiteOutputWriterCommonSettings.getHostAndPort(settings);
        this.messageBuilder = new GraphiteMetricMessageBuilder(GraphiteOutputWriterCommonSettings.getConfiguredMetricPrefixOrNull(settings));
        this.messageSender = new UdpMessageSender(this.graphiteServerHostAndPort);
        this.clock = new SystemCurrentTimeMillisClock();
        this.logger.log(this.getInfoLevel(), "GraphiteUdpOutputWriter is configured with " + this.graphiteServerHostAndPort + ", metricPathPrefix=" + this.messageBuilder.getPrefix());
    }

    @Override
    public void writeInvocationResult(String invocationName, Object value) throws IOException {
        this.writeQueryResult(invocationName, null, value);
    }

    @Override
    public void writeQueryResult(String metricName, String metricType, Object value) throws IOException {
        String msg = this.messageBuilder.buildMessage(metricName, value, TimeUnit.SECONDS.convert(this.clock.getCurrentTimeMillis(), TimeUnit.MILLISECONDS));
        this.logMessageIfTraceLoggable(msg);
        this.tryWriteMsg(msg + "\n");
    }

    private void logMessageIfTraceLoggable(String msg) {
        if (this.logger.isLoggable(this.getTraceLevel())) {
            this.logger.log(this.getTraceLevel(), "Send '" + msg + "' to " + this.graphiteServerHostAndPort);
        }
    }

    private void tryWriteMsg(String msg) throws IOException {
        try {
            this.messageSender.send(msg);
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "Exception sending '" + msg + "' to " + this.graphiteServerHostAndPort, e);
            throw e;
        }
    }

    @Override
    public void preDestroy() {
        super.preDestroy();
        if (this.messageSender != null) {
            this.messageSender.close();
        }
    }

    public String toString() {
        return "GraphiteUdpOutputWriter{, " + this.graphiteServerHostAndPort + ", metricPathPrefix='" + this.messageBuilder.getPrefix() + "'" + "}";
    }

    void setClock(Clock clock) {
        this.clock = clock;
    }

    private static class UdpMessageSender {
        private final DatagramSocket clientSocket;
        private final HostAndPort hostAndPort;

        public UdpMessageSender(HostAndPort hostAndPort) {
            this.hostAndPort = hostAndPort;
            try {
                this.clientSocket = new DatagramSocket();
            }
            catch (SocketException e) {
                throw new RuntimeException("Failed to create DatagramSocket", e);
            }
        }

        public void send(String msg) throws IOException {
            DatagramPacket packetToSend = this.createUdpPacket(msg);
            this.clientSocket.send(packetToSend);
        }

        private DatagramPacket createUdpPacket(String msg) throws SocketException {
            byte[] messageBytes = msg.getBytes(CHARSET_FOR_UDP_PACKET);
            InetSocketAddress adress = new InetSocketAddress(this.hostAndPort.getHost(), this.hostAndPort.getPort());
            return new DatagramPacket(messageBytes, messageBytes.length, adress);
        }

        public void close() {
            this.clientSocket.close();
        }
    }
}

