/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent.influxdb;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jmxtrans.agent.influxdb.InfluxTag;
import org.jmxtrans.agent.util.StringUtils2;

public class InfluxMetric {
    private static final String FIELD_NAME = "value";
    private final long timestampMillis;
    private final List<InfluxTag> tags;
    private final String measurement;
    private final Object value;

    public InfluxMetric(String measurement, List<InfluxTag> tags, Object value, long timestampMillis) {
        this.measurement = Objects.requireNonNull(measurement);
        this.tags = Objects.requireNonNull(tags);
        this.value = Objects.requireNonNull(value);
        this.timestampMillis = timestampMillis;
    }

    public long getTimestampMillis() {
        return this.timestampMillis;
    }

    public List<InfluxTag> getTags() {
        return this.tags;
    }

    public String getMeasurement() {
        return this.measurement;
    }

    public Object getValue() {
        return this.valueAsStr();
    }

    public String toInfluxFormat() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.measurement);
        if (!this.tags.isEmpty()) {
            sb.append(",");
        }
        sb.append(StringUtils2.join(this.convertTagsToStrings(), ",")).append(" ").append(FIELD_NAME).append("=").append(this.valueAsStr()).append(" ").append(this.timestampMillis);
        return sb.toString();
    }

    private String valueAsStr() {
        if (this.value instanceof Integer || this.value instanceof Long) {
            return this.value.toString() + "i";
        }
        return this.value.toString();
    }

    private List<String> convertTagsToStrings() {
        ArrayList<String> l = new ArrayList<String>(this.tags.size());
        for (InfluxTag influxTag : this.tags) {
            l.add(influxTag.toInfluxFormat());
        }
        return l;
    }

    public int hashCode() {
        return Objects.hash(this.timestampMillis, this.tags, this.measurement, this.valueAsStr());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InfluxMetric other = (InfluxMetric)obj;
        return Objects.equals(this.timestampMillis, other.timestampMillis) && Objects.equals(this.tags, other.tags) && Objects.equals(this.measurement, other.measurement) && Objects.equals(this.valueAsStr(), other.valueAsStr());
    }

    public String toString() {
        return "InfluxMetric [timestampMillis=" + this.timestampMillis + ", tags=" + this.tags + ", measurement=" + this.measurement + ", value=" + this.value + "]";
    }
}

