/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent.influxdb;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jmxtrans.agent.AbstractOutputWriter;
import org.jmxtrans.agent.influxdb.InfluxMetric;
import org.jmxtrans.agent.influxdb.InfluxMetricConverter;
import org.jmxtrans.agent.influxdb.InfluxTag;
import org.jmxtrans.agent.util.ConfigurationUtils;
import org.jmxtrans.agent.util.io.IoRuntimeException;
import org.jmxtrans.agent.util.io.IoUtils;
import org.jmxtrans.agent.util.time.Clock;
import org.jmxtrans.agent.util.time.SystemCurrentTimeMillisClock;

public class InfluxDbOutputWriter
extends AbstractOutputWriter {
    private URL url;
    private String database;
    private String user;
    private String password;
    private String retentionPolicy;
    private List<InfluxTag> tags;
    private List<InfluxMetric> batchedMetrics = new ArrayList<InfluxMetric>();
    private int connectTimeoutMillis;
    private int readTimeoutMillis;
    private final Clock clock;
    private boolean enabled;
    public static final String SETTING_ENABLED = "enabled";

    public InfluxDbOutputWriter() {
        this.clock = new SystemCurrentTimeMillisClock();
    }

    InfluxDbOutputWriter(Clock clock) {
        this.clock = clock;
    }

    @Override
    public void postConstruct(Map<String, String> settings) {
        this.enabled = ConfigurationUtils.getBoolean(settings, SETTING_ENABLED, true);
        String urlStr = ConfigurationUtils.getString(settings, "url");
        this.database = ConfigurationUtils.getString(settings, "database");
        this.user = ConfigurationUtils.getString(settings, "user", null);
        this.password = ConfigurationUtils.getString(settings, "password", null);
        this.retentionPolicy = ConfigurationUtils.getString(settings, "retentionPolicy", null);
        String tagsStr = ConfigurationUtils.getString(settings, "tags", "");
        this.tags = InfluxMetricConverter.tagsFromCommaSeparatedString(tagsStr);
        this.connectTimeoutMillis = ConfigurationUtils.getInt(settings, "connectTimeoutMillis", 3000);
        this.readTimeoutMillis = ConfigurationUtils.getInt(settings, "readTimeoutMillis", 5000);
        this.url = this.parseUrlStr(this.getWriteEndpointForUrlStr(urlStr));
        this.logger.log(this.getInfoLevel(), "InfluxDbOutputWriter is configured with url=" + urlStr + ", database=" + this.database + ", user=" + this.user + ", password=" + (this.password != null ? "****" : null) + ", tags=" + tagsStr + ", connectTimeoutMills=" + this.connectTimeoutMillis + ", readTimeoutMillis=" + this.readTimeoutMillis);
    }

    private String getWriteEndpointForUrlStr(String urlStr) {
        return urlStr + (urlStr.endsWith("/") ? "write" : "/write");
    }

    private URL parseUrlStr(String urlStr) {
        try {
            return new URL(urlStr + "?" + this.buildQueryString());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private String buildQueryString() {
        StringBuilder sb = new StringBuilder();
        sb.append("precision=ms").append("&db=").append(this.database);
        this.appendParamIfNotEmptyOrNull(sb, "u", this.user);
        this.appendParamIfNotEmptyOrNull(sb, "p", this.password);
        this.appendParamIfNotEmptyOrNull(sb, "rp", this.retentionPolicy);
        return sb.toString();
    }

    @Override
    public void writeInvocationResult(String invocationName, Object value) throws IOException {
        if (!this.enabled) {
            return;
        }
        this.writeQueryResult(invocationName, null, value);
    }

    @Override
    public void writeQueryResult(String metricName, String metricType, Object value) throws IOException {
        if (!this.enabled) {
            return;
        }
        InfluxMetric metric = InfluxMetricConverter.convertToInfluxMetric(metricName, value, this.tags, this.clock.getCurrentTimeMillis());
        this.batchedMetrics.add(metric);
    }

    @Override
    public void postCollect() throws IOException {
        if (!this.enabled) {
            return;
        }
        String body = this.convertMetricsToLines(this.batchedMetrics);
        String queryString = this.buildQueryString();
        if (this.logger.isLoggable(this.getTraceLevel())) {
            this.logger.log(this.getTraceLevel(), "Sending to influx (" + this.url + "):\n" + body);
        }
        this.batchedMetrics.clear();
        this.sendMetrics(queryString, body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMetrics(String queryString, String body) throws IOException {
        HttpURLConnection conn = this.createAndConfigureConnection();
        try {
            this.sendMetrics(body, conn);
        }
        finally {
            IoUtils.closeQuietly(conn);
        }
    }

    private void sendMetrics(String body, HttpURLConnection conn) throws IOException {
        this.writeMetrics(conn, body);
        int responseCode = conn.getResponseCode();
        if (responseCode / 100 != 2) {
            throw new RuntimeException("Failed to write metrics, response code: " + responseCode + ", response message: " + conn.getResponseMessage());
        }
        String response = this.readResponse(conn);
        this.logger.log(this.getTraceLevel(), "Response from influx: " + response);
    }

    private HttpURLConnection createAndConfigureConnection() throws ProtocolException {
        HttpURLConnection conn = this.openHttpConnection();
        conn.setConnectTimeout(this.connectTimeoutMillis);
        conn.setReadTimeout(this.readTimeoutMillis);
        conn.setDoOutput(true);
        conn.setRequestMethod("POST");
        return conn;
    }

    private HttpURLConnection openHttpConnection() {
        try {
            return (HttpURLConnection)this.url.openConnection();
        }
        catch (IOException | ClassCastException e) {
            throw new IoRuntimeException("Failed to create HttpURLConnection to " + this.url + " - is it a valid HTTP url?", e);
        }
    }

    private void writeMetrics(HttpURLConnection conn, String body) throws UnsupportedEncodingException, IOException {
        byte[] toSendBytes = body.getBytes("UTF-8");
        conn.setRequestProperty("Content-Length", Integer.toString(toSendBytes.length));
        try (OutputStream os = conn.getOutputStream();){
            os.write(toSendBytes);
            os.flush();
        }
    }

    private String readResponse(HttpURLConnection conn) throws IOException, UnsupportedEncodingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (InputStream is = conn.getInputStream();){
            IoUtils.copy(is, baos);
        }
        String response = new String(baos.toByteArray(), "UTF-8");
        return response;
    }

    private void appendParamIfNotEmptyOrNull(StringBuilder sb, String paramName, String paramValue) {
        if (paramValue != null && !paramValue.trim().isEmpty()) {
            sb.append("&").append(paramName).append("=").append(paramValue);
        }
    }

    private String convertMetricsToLines(List<InfluxMetric> metrics) {
        StringBuilder sb = new StringBuilder();
        Iterator<InfluxMetric> it = metrics.iterator();
        while (it.hasNext()) {
            InfluxMetric metric = it.next();
            sb.append(metric.toInfluxFormat());
            if (!it.hasNext()) continue;
            sb.append("\n");
        }
        return sb.toString();
    }
}

