/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent.zabbix;

import java.util.Map;
import org.jmxtrans.agent.util.ConfigurationUtils;
import org.jmxtrans.agent.util.net.HostAndPort;

public class ZabbixOutputWriterCommonSettings {
    public static final String SETTING_HOST = "host";
    public static final String SETTING_PORT = "port";
    public static final int SETTING_PORT_DEFAULT_VALUE = 2003;
    public static final String SETTING_SERVER_NAME = "serverName";
    public static final String SETTING_BATCH_SIZE = "batchSize";
    public static final int SETTING_BATCH_SIZE_DEFAULT_VALUE = 1000;

    private ZabbixOutputWriterCommonSettings() {
    }

    public static HostAndPort getHostAndPort(Map<String, String> settings) {
        return new HostAndPort(ConfigurationUtils.getString(settings, SETTING_HOST), ConfigurationUtils.getInt(settings, SETTING_PORT, 2003));
    }

    public static String getConfiguredHostName(Map<String, String> settings) {
        return ConfigurationUtils.getString(settings, SETTING_SERVER_NAME, null);
    }

    public static int getMetricBatchSize(Map<String, String> settings) {
        return ConfigurationUtils.getInt(settings, SETTING_BATCH_SIZE, 1000);
    }
}

