/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent.properties;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.jmxtrans.agent.properties.PropertiesLoader;
import org.jmxtrans.agent.util.Preconditions2;
import org.jmxtrans.agent.util.io.IoRuntimeException;
import org.jmxtrans.agent.util.io.Resource;
import org.jmxtrans.agent.util.io.ResourceFactory;

public class ResourcePropertiesLoader
implements PropertiesLoader {
    private final Resource resource;

    public ResourcePropertiesLoader(@Nonnull Resource resource) {
        this.resource = Preconditions2.checkNotNull(resource, "resources");
    }

    public ResourcePropertiesLoader(@Nonnull String resourcesPath) {
        this.resource = ResourceFactory.newResource(resourcesPath);
    }

    @Override
    public Map<String, String> loadProperties() {
        Properties properties = new Properties();
        try {
            InputStream in = this.resource.getInputStream();
            Object object = null;
            try {
                properties.load(in);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (in != null) {
                    if (object != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        in.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new IoRuntimeException("Exception loading properties from " + this.resource, e);
        }
        HashMap<String, String> result = new HashMap<String, String>(properties.size());
        for (String key : properties.stringPropertyNames()) {
            result.put(key, properties.getProperty(key));
        }
        return result;
    }

    public String toString() {
        return "ResourcePropertiesLoader{resource=" + this.resource + '}';
    }

    @Override
    public String getDescription() {
        return "PropertiesLoader for " + this.resource.getDescription();
    }
}

