/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent;

import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jmxtrans.agent.OutputWriter;
import org.jmxtrans.agent.Query;
import org.jmxtrans.agent.ResultNameStrategy;
import org.jmxtrans.agent.util.StringUtils2;
import org.jmxtrans.agent.util.json.JsonArray;
import org.jmxtrans.agent.util.json.JsonObject;
import org.jmxtrans.agent.util.logging.Logger;

public class DiscoveryQuery
extends Query {
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    public DiscoveryQuery(String objectName, List<String> attributes, String key, Integer position, String type, String resultAlias, ResultNameStrategy resultNameStrategy, Integer collectInterval) {
        super(objectName, attributes, key, position, type, resultAlias, resultNameStrategy, collectInterval);
    }

    @Override
    public void collectAndExport(MBeanServer mbeanServer, OutputWriter outputWriter) {
        if (this.resultNameStrategy == null) {
            throw new IllegalStateException("resultNameStrategy is not defined, query object is not properly initialized");
        }
        try {
            Set<ObjectName> objectNames = mbeanServer.queryNames(this.objectName, null);
            String discoveryResult = this.formatDiscoveryValue(objectNames);
            String resultName = this.resultNameStrategy.getResultName(this, this.objectName, null, null, null);
            String type = this.getType();
            outputWriter.writeQueryResult(resultName, type, discoveryResult);
        }
        catch (Exception ex) {
            this.logger.log(Level.WARNING, "DiscoveryQuery. Exception collecting " + this.objectName + "#" + this.getAttributes() + (this.key == null ? "" : "#" + this.key), ex);
        }
    }

    private String formatDiscoveryValue(Set<ObjectName> objectNames) {
        JsonObject result = new JsonObject();
        JsonArray data = new JsonArray();
        result.add("data", data);
        for (ObjectName on : objectNames) {
            try {
                JsonObject discoveredObject = new JsonObject();
                for (String attribute : this.attributes) {
                    String keyProperty = on.getKeyProperty(attribute);
                    if (keyProperty == null) continue;
                    String formattedKey = this.formatDiscoveryKey(attribute);
                    String formattedValue = this.formatDiscoveryValue(keyProperty);
                    discoveredObject.add(formattedKey, formattedValue);
                }
                data.add(discoveredObject);
            }
            catch (Exception ex) {
                this.logger.log(Level.WARNING, "DiscoveryQuery.formatDiscoveryValue. Exception collecting " + this.objectName + "#" + this.getAttributes() + (this.key == null ? "" : "#" + this.key), ex);
            }
        }
        String discoveryResult = result.toString();
        return discoveryResult;
    }

    public String formatDiscoveryValue(String keyProperty) {
        StringBuilder builder = new StringBuilder();
        StringUtils2.appendEscapedNonAlphaNumericChars(keyProperty, builder);
        keyProperty = builder.toString();
        return keyProperty;
    }

    private String formatDiscoveryKey(String attribute) {
        return "{#" + attribute.toUpperCase() + "}";
    }
}

