/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.management.ObjectName;
import org.jmxtrans.agent.ExpressionLanguageEngine;
import org.jmxtrans.agent.util.StringUtils2;
import org.jmxtrans.agent.util.logging.Logger;

public class ExpressionLanguageEngineImpl
implements ExpressionLanguageEngine {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    @Nonnull
    private Map<String, Function> functionsByName = new HashMap<String, Function>();

    public ExpressionLanguageEngineImpl() {
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            String hostName = localHost.getHostName();
            String reversedHostName = StringUtils2.reverseTokens(hostName, ".");
            String canonicalHostName = localHost.getCanonicalHostName();
            String reversedCanonicalHostName = StringUtils2.reverseTokens(canonicalHostName, ".");
            String hostAddress = localHost.getHostAddress();
            this.functionsByName.put("hostname", new StaticFunction(hostName));
            this.functionsByName.put("reversed_hostname", new StaticFunction(reversedHostName));
            this.functionsByName.put("escaped_hostname", new StaticFunction(hostName.replaceAll("\\.", "_")));
            this.functionsByName.put("canonical_hostname", new StaticFunction(canonicalHostName));
            this.functionsByName.put("reversed_canonical_hostname", new StaticFunction(reversedCanonicalHostName));
            this.functionsByName.put("escaped_canonical_hostname", new StaticFunction(canonicalHostName.replaceAll("\\.", "_")));
            this.functionsByName.put("hostaddress", new StaticFunction(hostAddress));
            this.functionsByName.put("escaped_hostaddress", new StaticFunction(hostAddress.replaceAll("\\.", "_")));
            this.functionsByName.put("attribute", new ExtractAttributeFunction());
            this.functionsByName.put("key", new ExtractCompositeDataKeyFunction());
            this.functionsByName.put("compositeDataKey", new ExtractCompositeDataKeyFunction());
            this.functionsByName.put("position", new ExtractPositionFunction());
            this.functionsByName.put("domain", new ExtractDomainFunction());
            this.functionsByName.put("reversed_domain", new ExtractReversedDomainFunction());
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Exception resolving localhost, expressions like #hostname#, #canonical_hostname# or #hostaddress# will not be available", e);
        }
    }

    @Override
    @Nonnull
    public String resolveExpression(@Nonnull String expression) {
        StringBuilder result = new StringBuilder(expression.length());
        int position = 0;
        while (position < expression.length()) {
            char c = expression.charAt(position);
            if (c == '#') {
                String value;
                int beginningSeparatorPosition = position;
                int endingSeparatorPosition = expression.indexOf(35, beginningSeparatorPosition + 1);
                if (endingSeparatorPosition == -1) {
                    throw new IllegalStateException("Invalid expression '" + expression + "', no ending '#' after beginning '#' at position " + beginningSeparatorPosition);
                }
                String key = expression.substring(beginningSeparatorPosition + 1, endingSeparatorPosition);
                Function expressionProcessor = this.functionsByName.get(key);
                if (expressionProcessor == null) {
                    value = "#unsupported_expression#";
                    this.logger.info("Unsupported expression '" + key + "'");
                } else {
                    try {
                        value = expressionProcessor.evaluate();
                    }
                    catch (Exception e) {
                        value = "#expression_error#";
                        this.logger.log(Level.WARNING, "Error evaluating expression '" + key + "'", e);
                    }
                }
                StringUtils2.appendEscapedNonAlphaNumericChars(value, false, result);
                position = endingSeparatorPosition + 1;
                continue;
            }
            result.append(c);
            ++position;
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.log(Level.FINEST, "resolveExpression(" + expression + "): " + result);
        }
        return result.toString();
    }

    @Override
    @Nonnull
    public String resolveExpression(@Nonnull String expression, @Nonnull ObjectName exactObjectName, @Nullable String attribute, @Nullable String compositeDataKey, @Nullable Integer position) {
        StringBuilder result = new StringBuilder(expression.length());
        int pos = 0;
        while (pos < expression.length()) {
            int endingSeparatorPosition;
            int beginningSeparatorPosition;
            char c = expression.charAt(pos);
            if (c == '%') {
                beginningSeparatorPosition = pos;
                endingSeparatorPosition = expression.indexOf(37, beginningSeparatorPosition + 1);
                if (endingSeparatorPosition == -1) {
                    throw new IllegalStateException("Invalid expression '" + expression + "', no ending '%' after beginning '%' at position " + beginningSeparatorPosition);
                }
                String objectNameKey = expression.substring(beginningSeparatorPosition + 1, endingSeparatorPosition);
                String value = exactObjectName.getKeyProperty(objectNameKey);
                if (value == null) {
                    value = "null";
                }
                StringUtils2.appendEscapedNonAlphaNumericChars(value, result);
                pos = endingSeparatorPosition + 1;
                continue;
            }
            if (c == '#') {
                String value;
                beginningSeparatorPosition = pos;
                endingSeparatorPosition = expression.indexOf(35, beginningSeparatorPosition + 1);
                if (endingSeparatorPosition == -1) {
                    throw new IllegalStateException("Invalid expression '" + expression + "', no ending '#' after beginning '#' at position " + beginningSeparatorPosition);
                }
                String functionName = expression.substring(beginningSeparatorPosition + 1, endingSeparatorPosition);
                Function function = this.functionsByName.get(functionName);
                if (function == null) {
                    value = "#unsupported_expression#";
                    this.logger.info("Unsupported expression '" + functionName + "'");
                } else {
                    try {
                        value = function.evaluate(exactObjectName, attribute, compositeDataKey, position);
                    }
                    catch (Exception e) {
                        value = "#expression_error#";
                        this.logger.log(Level.WARNING, "Error evaluating expression '" + compositeDataKey + "'", e);
                    }
                }
                StringUtils2.appendEscapedNonAlphaNumericChars(value, false, result);
                pos = endingSeparatorPosition + 1;
                continue;
            }
            result.append(c);
            ++pos;
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.log(Level.FINEST, "resolveExpression(" + expression + ", " + exactObjectName + "): " + result);
        }
        return result.toString();
    }

    public void registerExpressionEvaluator(@Nonnull String expression, @Nonnull Function evaluator) {
        this.functionsByName.put(expression, evaluator);
    }

    private static class ExtractReversedDomainFunction
    implements Function {
        private ExtractReversedDomainFunction() {
        }

        @Override
        public String evaluate() {
            return null;
        }

        @Override
        public String evaluate(@Nullable ObjectName objectName, @Nullable String attribute, @Nullable String compositeDataKey, @Nullable Integer position) {
            return objectName == null ? null : StringUtils2.reverseTokens(objectName.getDomain(), ".");
        }
    }

    private static class ExtractDomainFunction
    implements Function {
        private ExtractDomainFunction() {
        }

        @Override
        public String evaluate() {
            return null;
        }

        @Override
        public String evaluate(@Nullable ObjectName objectName, @Nullable String attribute, @Nullable String compositeDataKey, @Nullable Integer position) {
            return objectName == null ? null : objectName.getDomain();
        }
    }

    private static class ExtractPositionFunction
    implements Function {
        private ExtractPositionFunction() {
        }

        @Override
        public String evaluate() {
            return null;
        }

        @Override
        public String evaluate(@Nullable ObjectName objectName, @Nullable String attribute, @Nullable String compositeDataKey, @Nullable Integer position) {
            return position == null ? null : position.toString();
        }
    }

    private static class ExtractCompositeDataKeyFunction
    implements Function {
        private ExtractCompositeDataKeyFunction() {
        }

        @Override
        public String evaluate() {
            return null;
        }

        @Override
        public String evaluate(@Nullable ObjectName objectName, @Nullable String attribute, @Nullable String compositeDataKey, @Nullable Integer position) {
            return compositeDataKey;
        }
    }

    private static class ExtractAttributeFunction
    implements Function {
        private ExtractAttributeFunction() {
        }

        @Override
        public String evaluate() {
            return null;
        }

        @Override
        public String evaluate(@Nullable ObjectName objectName, @Nullable String attribute, @Nullable String compositeDataKey, @Nullable Integer position) {
            return attribute;
        }
    }

    public static class StaticFunction
    implements Function {
        final String value;

        public StaticFunction(String value) {
            this.value = value;
        }

        @Override
        public String evaluate() {
            return this.value;
        }

        @Override
        public String evaluate(@Nullable ObjectName objectName, @Nullable String attribute, @Nullable String compositeDataKey, @Nullable Integer position) {
            return this.value;
        }

        public String toString() {
            return "StaticFunction{value='" + this.value + '\'' + '}';
        }
    }

    public static interface Function {
        @Nullable
        public String evaluate();

        @Nullable
        public String evaluate(@Nullable ObjectName var1, @Nullable String var2, @Nullable String var3, @Nullable Integer var4);
    }
}

