/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.management.ObjectName;
import org.jmxtrans.agent.ExpressionLanguageEngine;
import org.jmxtrans.agent.ExpressionLanguageEngineImpl;
import org.jmxtrans.agent.Query;
import org.jmxtrans.agent.ResultNameStrategy;
import org.jmxtrans.agent.util.StringUtils2;
import org.jmxtrans.agent.util.logging.Logger;

public class JConsoleResultNameStrategyImpl
implements ResultNameStrategy {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    private ExpressionLanguageEngine expressionLanguageEngine = new ExpressionLanguageEngineImpl();

    @Override
    @Nonnull
    public String getResultName(@Nonnull Query query, @Nonnull ObjectName objectName, @Nullable String attribute, @Nullable String compositeDataKey, @Nullable Integer position) {
        String result;
        if (query.getResultAlias() == null) {
            result = this.escapeObjectName(objectName);
            if (!StringUtils2.isNullOrEmpty(attribute)) {
                result = result + "." + attribute;
            }
            if (!StringUtils2.isNullOrEmpty(compositeDataKey)) {
                result = result + "." + compositeDataKey;
            }
            if (position != null) {
                result = result + "_" + position;
            }
        } else {
            result = this.expressionLanguageEngine.resolveExpression(query.getResultAlias(), objectName, attribute, compositeDataKey, position);
        }
        return result;
    }

    protected String escapeObjectName(@Nonnull ObjectName objectName) {
        StringBuilder result = new StringBuilder();
        StringUtils2.appendEscapedNonAlphaNumericChars(objectName.getDomain(), false, result);
        ArrayList<String> keys = Collections.list(objectName.getKeyPropertyList().keys());
        Collections.sort(keys);
        for (String propertyKey : keys) {
            result.append('.');
            StringUtils2.appendEscapedNonAlphaNumericChars(objectName.getKeyProperty(propertyKey), false, result);
        }
        return result.toString();
    }

    public ExpressionLanguageEngine getExpressionLanguageEngine() {
        return this.expressionLanguageEngine;
    }

    public void setExpressionLanguageEngine(ExpressionLanguageEngine expressionLanguageEngine) {
        this.expressionLanguageEngine = expressionLanguageEngine;
    }

    @Override
    public void postConstruct(@Nonnull Map<String, String> settings) {
    }
}

