/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.jmxtrans.agent.ExpressionLanguageEngine;
import org.jmxtrans.agent.ExpressionLanguageEngineImpl;
import org.jmxtrans.agent.JmxTransConfigurationLoader;
import org.jmxtrans.agent.JmxTransExporterConfiguration;
import org.jmxtrans.agent.OutputWriter;
import org.jmxtrans.agent.OutputWriterCircuitBreakerDecorator;
import org.jmxtrans.agent.OutputWritersChain;
import org.jmxtrans.agent.ResultNameStrategy;
import org.jmxtrans.agent.ResultNameStrategyImpl;
import org.jmxtrans.agent.properties.NoPropertiesSourcePropertiesLoader;
import org.jmxtrans.agent.properties.PropertiesLoader;
import org.jmxtrans.agent.util.Preconditions2;
import org.jmxtrans.agent.util.PropertyPlaceholderResolver;
import org.jmxtrans.agent.util.io.IoRuntimeException;
import org.jmxtrans.agent.util.io.IoUtils;
import org.jmxtrans.agent.util.io.Resource;
import org.jmxtrans.agent.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class JmxTransConfigurationXmlLoader
implements JmxTransConfigurationLoader {
    private static final String COLLECT_INTERVAL_NAME = "collectIntervalInSeconds";
    private static final Pattern ATTRIBUTE_SPLIT_PATTERN = Pattern.compile("\\s*,\\s*");
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private final PropertiesLoader propertiesLoader;
    @Nonnull
    private final Resource configurationResource;
    private ExpressionLanguageEngine expressionLanguageEngine;

    public JmxTransConfigurationXmlLoader(@Nonnull Resource configurationResource, @Nonnull PropertiesLoader propertiesLoader, @Nonnull ExpressionLanguageEngine expressionLanguageEngine) {
        this.configurationResource = Preconditions2.checkNotNull(configurationResource, "configurationResource can not be null");
        this.propertiesLoader = Preconditions2.checkNotNull(propertiesLoader, "propertiesLoader can not be null");
        this.expressionLanguageEngine = Preconditions2.checkNotNull(expressionLanguageEngine, "expressionLanguageEngine can not be null");
    }

    JmxTransConfigurationXmlLoader(@Nonnull Resource configurationResource, PropertiesLoader propertiesLoader) {
        this(configurationResource, propertiesLoader, new ExpressionLanguageEngineImpl());
    }

    JmxTransConfigurationXmlLoader(@Nonnull Resource configurationResource) {
        this(configurationResource, new NoPropertiesSourcePropertiesLoader(), new ExpressionLanguageEngineImpl());
    }

    @Override
    public JmxTransExporterConfiguration loadConfiguration() {
        return this.build(IoUtils.getFileAsDocument(this.configurationResource));
    }

    @Override
    public long lastModified() {
        try {
            return this.configurationResource.lastModified();
        }
        catch (IoRuntimeException e) {
            return 0L;
        }
    }

    protected JmxTransExporterConfiguration build(Document document) {
        Integer reloadConfigInterval;
        Element rootElement = document.getDocumentElement();
        Map<String, String> loadedProperties = this.loadPropertiesOrEmptyOnException();
        PropertyPlaceholderResolver resolver = new PropertyPlaceholderResolver(loadedProperties);
        JmxTransExporterConfiguration jmxTransExporterConfiguration = new JmxTransExporterConfiguration(document);
        Integer collectInterval = this.getIntegerElementValueOrNullIfNotSet(rootElement, COLLECT_INTERVAL_NAME, resolver);
        if (collectInterval != null) {
            jmxTransExporterConfiguration.withCollectInterval(collectInterval, TimeUnit.SECONDS);
        }
        if ((reloadConfigInterval = this.getIntegerElementValueOrNullIfNotSet(rootElement, "reloadConfigurationCheckIntervalInSeconds", resolver)) != null) {
            jmxTransExporterConfiguration.withConfigReloadInterval(reloadConfigInterval);
        }
        this.buildResultNameStrategy(rootElement, jmxTransExporterConfiguration, resolver);
        this.buildInvocations(rootElement, jmxTransExporterConfiguration);
        this.buildQueries(rootElement, jmxTransExporterConfiguration);
        this.buildDiscoveryQueries(rootElement, jmxTransExporterConfiguration);
        this.buildOutputWriters(rootElement, jmxTransExporterConfiguration, resolver);
        return jmxTransExporterConfiguration;
    }

    @Nonnull
    private Map<String, String> loadPropertiesOrEmptyOnException() {
        try {
            return this.propertiesLoader.loadProperties();
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Error when loading properties from loader " + this.propertiesLoader + ", this source will be ignored", e);
            return new HashMap<String, String>();
        }
    }

    public JmxTransExporterConfiguration build(JmxTransConfigurationLoader configurationDocumentLoader) throws Exception {
        JmxTransExporterConfiguration configuration = configurationDocumentLoader.loadConfiguration();
        return this.build(configuration.getDocument());
    }

    private Integer getIntegerElementValueOrNullIfNotSet(Element rootElement, String elementName, PropertyPlaceholderResolver placeholderResolver) {
        NodeList nodeList = rootElement.getElementsByTagName(elementName);
        switch (nodeList.getLength()) {
            case 0: {
                return null;
            }
            case 1: {
                Element element = (Element)nodeList.item(0);
                String stringValue = placeholderResolver.resolveString(element.getTextContent());
                try {
                    return Integer.parseInt(stringValue);
                }
                catch (NumberFormatException e) {
                    throw new IllegalStateException("Invalid <" + elementName + "> value '" + stringValue + "', integer expected", e);
                }
            }
        }
        this.logger.warning("More than 1 <" + elementName + "> element found (" + nodeList.getLength() + "), use latest");
        Element lastElement = (Element)nodeList.item(nodeList.getLength() - 1);
        String lastStringValue = placeholderResolver.resolveString(lastElement.getTextContent());
        try {
            return Integer.parseInt(lastStringValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("Invalid <" + elementName + "> value '" + lastStringValue + "', integer expected", e);
        }
    }

    private void buildQueries(Element rootElement, JmxTransExporterConfiguration configuration) {
        NodeList queries = rootElement.getElementsByTagName("query");
        for (int i = 0; i < queries.getLength(); ++i) {
            Integer position;
            Element queryElement = (Element)queries.item(i);
            String objectName = queryElement.getAttribute("objectName");
            List<String> attributes = this.getAttributes(queryElement, objectName);
            String key = queryElement.hasAttribute("key") ? queryElement.getAttribute("key") : null;
            String resultAlias = queryElement.hasAttribute("resultAlias") ? queryElement.getAttribute("resultAlias") : null;
            String type = queryElement.getAttribute("type");
            try {
                position = queryElement.hasAttribute("position") ? Integer.valueOf(Integer.parseInt(queryElement.getAttribute("position"))) : null;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid 'position' attribute for query objectName=" + objectName + ", attributes=" + attributes + ", resultAlias=" + resultAlias);
            }
            Integer collectInterval = this.intAttributeOrNull(queryElement, COLLECT_INTERVAL_NAME);
            configuration.withQuery(objectName, attributes, key, position, type, resultAlias, collectInterval);
        }
    }

    private void buildDiscoveryQueries(Element rootElement, JmxTransExporterConfiguration configuration) {
        NodeList queries = rootElement.getElementsByTagName("discoveryQuery");
        for (int i = 0; i < queries.getLength(); ++i) {
            Integer position;
            Element queryElement = (Element)queries.item(i);
            String objectName = queryElement.getAttribute("objectName");
            List<String> attributes = this.getAttributes(queryElement, objectName);
            String key = queryElement.hasAttribute("key") ? queryElement.getAttribute("key") : null;
            String resultAlias = queryElement.getAttribute("resultAlias");
            String type = queryElement.getAttribute("type");
            try {
                position = queryElement.hasAttribute("position") ? Integer.valueOf(Integer.parseInt(queryElement.getAttribute("position"))) : null;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid 'position' attribute for query objectName=" + objectName + ", attributes=" + attributes + ", resultAlias=" + resultAlias);
            }
            Integer collectInterval = this.intAttributeOrNull(queryElement, COLLECT_INTERVAL_NAME);
            configuration.withDiscoveryQuery(objectName, attributes, key, position, type, resultAlias, collectInterval);
        }
    }

    private List<String> getAttributes(Element queryElement, String objectName) {
        String attribute = queryElement.getAttribute("attribute");
        String attributes = queryElement.getAttribute("attributes");
        this.validateOnlyAttributeOrAttributesSpecified(attribute, attributes, objectName);
        if (attribute.isEmpty() && attributes.isEmpty()) {
            return Collections.emptyList();
        }
        if (!attribute.isEmpty()) {
            return Collections.singletonList(attribute);
        }
        String[] splitAttributes = ATTRIBUTE_SPLIT_PATTERN.split(attributes);
        return Arrays.asList(splitAttributes);
    }

    private void validateOnlyAttributeOrAttributesSpecified(String attribute, String attributes, String objectName) {
        if (!attribute.isEmpty() && !attributes.isEmpty()) {
            throw new IllegalArgumentException("Only one of 'attribute' and 'attributes' is supported for a query - not both - objectName: " + objectName);
        }
    }

    private void buildInvocations(Element rootElement, JmxTransExporterConfiguration configuration) {
        NodeList invocations = rootElement.getElementsByTagName("invocation");
        for (int i = 0; i < invocations.getLength(); ++i) {
            Element invocationElement = (Element)invocations.item(i);
            String objectName = invocationElement.getAttribute("objectName");
            String operation = invocationElement.getAttribute("operation");
            String resultAlias = invocationElement.getAttribute("resultAlias");
            Integer collectInterval = this.intAttributeOrNull(invocationElement, COLLECT_INTERVAL_NAME);
            configuration.withInvocation(objectName, operation, resultAlias, collectInterval);
        }
    }

    private Integer intAttributeOrNull(Element element, String attributeName) {
        String value = element.getAttribute(attributeName);
        if (value.isEmpty()) {
            return null;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Attribute '" + attributeName + "' must be an integer", e);
        }
    }

    private void buildResultNameStrategy(Element rootElement, JmxTransExporterConfiguration configuration, PropertyPlaceholderResolver placeholderResolver) {
        ResultNameStrategy resultNameStrategy;
        NodeList resultNameStrategyNodeList = rootElement.getElementsByTagName("resultNameStrategy");
        switch (resultNameStrategyNodeList.getLength()) {
            case 0: {
                resultNameStrategy = new ResultNameStrategyImpl(this.expressionLanguageEngine);
                break;
            }
            case 1: {
                Element resultNameStrategyElement = (Element)resultNameStrategyNodeList.item(0);
                String outputWriterClass = resultNameStrategyElement.getAttribute("class");
                if (outputWriterClass.isEmpty()) {
                    throw new IllegalArgumentException("<resultNameStrategy> element must contain a 'class' attribute");
                }
                try {
                    resultNameStrategy = (ResultNameStrategy)Class.forName(outputWriterClass).newInstance();
                    HashMap<String, String> settings = new HashMap<String, String>();
                    NodeList settingsNodeList = resultNameStrategyElement.getElementsByTagName("*");
                    for (int j = 0; j < settingsNodeList.getLength(); ++j) {
                        Element settingElement = (Element)settingsNodeList.item(j);
                        settings.put(settingElement.getNodeName(), placeholderResolver.resolveString(settingElement.getTextContent()));
                    }
                    resultNameStrategy.postConstruct(settings);
                    break;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Exception instantiating " + outputWriterClass, e);
                }
            }
            default: {
                throw new IllegalStateException("More than 1 <resultNameStrategy> element found (" + resultNameStrategyNodeList.getLength() + ")");
            }
        }
        configuration.resultNameStrategy = resultNameStrategy;
    }

    private void buildOutputWriters(Element rootElement, JmxTransExporterConfiguration configuration, PropertyPlaceholderResolver placeholderResolver) {
        NodeList outputWriterNodeList = rootElement.getElementsByTagName("outputWriter");
        ArrayList<OutputWriter> outputWriters = new ArrayList<OutputWriter>();
        for (int i = 0; i < outputWriterNodeList.getLength(); ++i) {
            Element outputWriterElement = (Element)outputWriterNodeList.item(i);
            String outputWriterClass = outputWriterElement.getAttribute("class");
            if (outputWriterClass.isEmpty()) {
                throw new IllegalArgumentException("<outputWriter> element must contain a 'class' attribute");
            }
            try {
                OutputWriter outputWriter = (OutputWriter)Class.forName(outputWriterClass).newInstance();
                HashMap<String, String> settings = new HashMap<String, String>();
                NodeList settingsNodeList = outputWriterElement.getElementsByTagName("*");
                for (int j = 0; j < settingsNodeList.getLength(); ++j) {
                    Element settingElement = (Element)settingsNodeList.item(j);
                    String settingText = settingElement.getTextContent();
                    String settingWithPlaceholdersResolved = placeholderResolver.resolveString(settingText);
                    String settingWithFunctionsApplied = this.expressionLanguageEngine.resolveExpression(settingWithPlaceholdersResolved);
                    settings.put(settingElement.getNodeName(), settingWithFunctionsApplied);
                }
                outputWriter = new OutputWriterCircuitBreakerDecorator(outputWriter);
                outputWriter.postConstruct(settings);
                outputWriters.add(outputWriter);
                continue;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Exception instantiating " + outputWriterClass, e);
            }
        }
        switch (outputWriters.size()) {
            case 0: {
                this.logger.warning("No outputwriter defined.");
                break;
            }
            case 1: {
                configuration.withOutputWriter((OutputWriter)outputWriters.get(0));
                break;
            }
            default: {
                configuration.withOutputWriter(new OutputWritersChain(outputWriters));
            }
        }
    }

    public String toString() {
        return "JmxTransConfigurationXmlLoader{configurationResource='" + this.configurationResource + '\'' + '}';
    }
}

