/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import org.jmxtrans.agent.Collector;
import org.jmxtrans.agent.OutputWriter;
import org.jmxtrans.agent.ResultNameStrategy;
import org.jmxtrans.agent.util.Preconditions2;
import org.jmxtrans.agent.util.collect.Iterables2;
import org.jmxtrans.agent.util.logging.Logger;

public class Query
implements Collector {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    @Nonnull
    protected ResultNameStrategy resultNameStrategy;
    @Nonnull
    protected final ObjectName objectName;
    @Nonnull
    protected List<String> attributes;
    @Nullable
    protected final String resultAlias;
    @Nullable
    protected final String key;
    @Nullable
    protected final Integer position;
    @Nullable
    private String type;
    @Nullable
    private Integer collectInterval;

    public Query(@Nonnull String objectName, @Nullable String attribute, @Nonnull ResultNameStrategy resultNameStrategy) {
        this(objectName, attribute, null, null, null, null, resultNameStrategy, null);
    }

    public Query(@Nonnull String objectName, @Nullable String attribute, int position, @Nonnull ResultNameStrategy resultNameStrategy) {
        this(objectName, attribute, null, (Integer)position, null, null, resultNameStrategy, null);
    }

    public Query(@Nonnull String objectName, @Nullable String attribute, @Nullable String resultAlias, @Nonnull ResultNameStrategy resultNameStrategy) {
        this(objectName, attribute, null, null, null, resultAlias, resultNameStrategy, null);
    }

    public Query(@Nonnull String objectName, @Nullable String attribute, @Nullable String key, @Nullable Integer position, @Nullable String type, @Nullable String resultAlias, @Nonnull ResultNameStrategy resultNameStrategy) {
        this(objectName, attribute, key, position, type, resultAlias, resultNameStrategy, null);
    }

    public Query(@Nonnull String objectName, @Nullable String attribute, @Nullable String key, @Nullable Integer position, @Nullable String type, @Nullable String resultAlias, @Nonnull ResultNameStrategy resultNameStrategy, @Nullable Integer collectInterval) {
        this(objectName, Query.nullOrEmtpy(attribute) ? Collections.emptyList() : Collections.singletonList(attribute), key, position, type, resultAlias, resultNameStrategy, collectInterval);
    }

    private static boolean nullOrEmtpy(String attribute) {
        return attribute == null || attribute.isEmpty();
    }

    public Query(@Nonnull String objectName, @Nonnull List<String> attributes, @Nullable String key, @Nullable Integer position, @Nullable String type, @Nullable String resultAlias, @Nonnull ResultNameStrategy resultNameStrategy, @Nullable Integer collectInterval) {
        try {
            this.objectName = new ObjectName(Preconditions2.checkNotNull(objectName));
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("Invalid objectName '" + objectName + "'", e);
        }
        this.attributes = Collections.unmodifiableList(new ArrayList(Preconditions2.checkNotNull(attributes, "attributes")));
        this.key = key;
        this.resultAlias = resultAlias;
        this.position = position;
        this.type = type;
        this.resultNameStrategy = Preconditions2.checkNotNull(resultNameStrategy, "resultNameStrategy");
        this.collectInterval = collectInterval;
    }

    @Override
    public void collectAndExport(@Nonnull MBeanServer mbeanServer, @Nonnull OutputWriter outputWriter) {
        if (this.resultNameStrategy == null) {
            throw new IllegalStateException("resultNameStrategy is not defined, query object is not properly initialized");
        }
        Set<ObjectName> objectNames = mbeanServer.queryNames(this.objectName, null);
        for (ObjectName on : objectNames) {
            this.collectAndExportForObjectName(mbeanServer, outputWriter, on);
        }
    }

    private void collectAndExportForObjectName(MBeanServer mbeanServer, OutputWriter outputWriter, ObjectName on) {
        for (String attribute : this.resolveAttributes(mbeanServer, on)) {
            this.collectAndExportAttribute(mbeanServer, outputWriter, on, attribute);
        }
    }

    private List<String> resolveAttributes(MBeanServer mbeanServer, ObjectName on) {
        if (this.attributes.isEmpty()) {
            return this.findAllAttributes(mbeanServer, on);
        }
        return this.attributes;
    }

    private List<String> findAllAttributes(MBeanServer mbeanServer, ObjectName on) {
        ArrayList<String> resolvedAttributes = new ArrayList<String>();
        try {
            for (MBeanAttributeInfo mBeanAttributeInfo : mbeanServer.getMBeanInfo(on).getAttributes()) {
                resolvedAttributes.add(mBeanAttributeInfo.getName());
            }
        }
        catch (InstanceNotFoundException | IntrospectionException | ReflectionException e) {
            this.logger.log(Level.WARNING, "Error when finding attributes for ObjectName " + on + ", all attributes will not be collected", e);
        }
        return resolvedAttributes;
    }

    private void collectAndExportAttribute(MBeanServer mbeanServer, OutputWriter outputWriter, ObjectName objectName, String attribute) {
        try {
            ArrayList<Object> value;
            ArrayList<Object> attributeValue = null;
            try {
                attributeValue = mbeanServer.getAttribute(objectName, attribute);
            }
            catch (Exception ex) {
                this.logger.warning("Failed to fetch attribute for '" + objectName + "'#" + attribute + ", exception: " + ex.getMessage());
                return;
            }
            if (attributeValue instanceof CompositeData) {
                CompositeData compositeData = (CompositeData)((Object)attributeValue);
                if (this.key == null) {
                    CompositeType compositeType = compositeData.getCompositeType();
                    for (String key : compositeType.keySet()) {
                        Object value2 = compositeData.get(key);
                        this.processAttributeValue(outputWriter, objectName, attribute, key, value2);
                    }
                    return;
                }
                value = compositeData.get(this.key);
            } else if (this.key == null) {
                value = attributeValue;
            } else {
                this.logger.warning("Ignore NON compositeData for specified key for '" + objectName + "'#" + attribute + "#" + this.key + ": " + attributeValue);
                return;
            }
            if (value != null && value.getClass().isArray()) {
                ArrayList<Object> valueAsList = new ArrayList<Object>();
                for (int i = 0; i < Array.getLength(value); ++i) {
                    valueAsList.add(Array.get(value, i));
                }
                value = valueAsList;
            }
            this.processAttributeValue(outputWriter, objectName, attribute, this.key, value);
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Exception collecting " + objectName + "#" + attribute + (this.key == null ? "" : "#" + this.key), e);
        }
    }

    private void processAttributeValue(@Nonnull OutputWriter outputWriter, @Nonnull ObjectName objectName, @Nonnull String attribute, @Nullable String compositeDataKey, Object value) throws IOException {
        if (value instanceof Iterable) {
            Iterable valueAsIterable = (Iterable)value;
            if (this.position == null) {
                int idx = 0;
                for (Object subValue : valueAsIterable) {
                    String resultName = this.resultNameStrategy.getResultName(this, objectName, attribute, compositeDataKey, idx);
                    outputWriter.writeQueryResult(resultName, this.type, subValue);
                    ++idx;
                }
            } else {
                String resultName = this.resultNameStrategy.getResultName(this, objectName, attribute, compositeDataKey, this.position);
                value = Iterables2.get((Iterable)value, this.position);
                outputWriter.writeQueryResult(resultName, this.type, value);
            }
        } else {
            String resultName = this.resultNameStrategy.getResultName(this, objectName, attribute, compositeDataKey, null);
            outputWriter.writeQueryResult(resultName, this.type, value);
        }
    }

    public String toString() {
        return "Query{objectName=" + this.objectName + ", resultAlias='" + this.resultAlias + '\'' + ", attributes='" + this.attributes + '\'' + ", key='" + this.key + '\'' + '}';
    }

    @Nonnull
    public ObjectName getObjectName() {
        return this.objectName;
    }

    @Nullable
    public String getResultAlias() {
        return this.resultAlias;
    }

    @Nullable
    public List<String> getAttributes() {
        return this.attributes;
    }

    @Nullable
    public String getKey() {
        return this.key;
    }

    @Nullable
    public Integer getPosition() {
        return this.position;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    @Nullable
    public Integer getCollectIntervalOverrideOrNull() {
        return this.collectInterval;
    }
}

