/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent;

import java.sql.Timestamp;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jmxtrans.agent.util.Preconditions2;

public class QueryResult {
    @Nonnull
    private final String name;
    private final long epochInMillis;
    @Nullable
    private final Object value;
    @Nullable
    private final String type;

    public QueryResult(@Nonnull String name, @Nullable Object value, long epochInMillis) {
        this(name, null, value, epochInMillis);
    }

    public QueryResult(@Nonnull String name, @Nullable String type, @Nullable Object value, long epochInMillis) {
        this.name = Preconditions2.checkNotEmpty(name);
        this.value = value;
        this.epochInMillis = epochInMillis;
        this.type = type;
    }

    public boolean isValueGreaterThan(QueryResult o) {
        if (this.value == null && o.value == null) {
            return false;
        }
        if (this.value == null && o.value != null) {
            return false;
        }
        if (this.value != null && o.value == null) {
            return true;
        }
        if (!(this.value instanceof Number)) {
            throw new IllegalArgumentException("This value is not a number: " + this);
        }
        if (!(o.value instanceof Number)) {
            throw new IllegalArgumentException("Other value is not a number: " + this);
        }
        if (!this.value.getClass().equals(o.value.getClass())) {
            throw new IllegalArgumentException("Value type mismatch: this.value " + this.value.getClass() + ", o.value " + o.value.getClass());
        }
        if (this.value instanceof Comparable) {
            return ((Comparable)this.value).compareTo(o.value) > 0;
        }
        throw new IllegalStateException("this value is not comparable " + this.value.getClass() + " - " + this.toString());
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    public long getEpochInMillis() {
        return this.epochInMillis;
    }

    public long getEpoch(TimeUnit timeUnit) {
        return timeUnit.convert(this.epochInMillis, TimeUnit.MILLISECONDS);
    }

    @Nullable
    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return "QueryResult{name='" + this.name + '\'' + ", epoch=" + new Timestamp(this.epochInMillis) + ", value=" + this.value + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QueryResult)) {
            return false;
        }
        QueryResult that = (QueryResult)o;
        if (this.epochInMillis != that.epochInMillis) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (int)(this.epochInMillis ^ this.epochInMillis >>> 32);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }
}

