/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.management.ObjectName;
import org.jmxtrans.agent.ExpressionLanguageEngine;
import org.jmxtrans.agent.ExpressionLanguageEngineImpl;
import org.jmxtrans.agent.Query;
import org.jmxtrans.agent.ResultNameStrategy;
import org.jmxtrans.agent.util.StringUtils2;
import org.jmxtrans.agent.util.logging.Logger;

public class ResultNameStrategyImpl
implements ResultNameStrategy {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    private ExpressionLanguageEngine expressionLanguageEngine;

    public ResultNameStrategyImpl() {
        this.expressionLanguageEngine = new ExpressionLanguageEngineImpl();
    }

    public ResultNameStrategyImpl(ExpressionLanguageEngine expressionLanguageEngine) {
        this.expressionLanguageEngine = expressionLanguageEngine;
    }

    @Override
    @Nonnull
    public String getResultName(@Nonnull Query query, @Nonnull ObjectName objectName, @Nonnull String attribute, @Nullable String compositeDataKey, @Nullable Integer position) {
        String result;
        if (query.getResultAlias() == null) {
            result = this.escapeObjectName(objectName);
            result = result + "." + attribute;
            if (compositeDataKey != null) {
                result = result + "." + compositeDataKey;
            }
            if (position != null) {
                result = result + "_" + position;
            }
        } else {
            result = this.expressionLanguageEngine.resolveExpression(query.getResultAlias(), objectName, attribute, compositeDataKey, position);
        }
        return result;
    }

    protected String escapeObjectName(@Nonnull ObjectName objectName) {
        StringBuilder result = new StringBuilder();
        StringUtils2.appendEscapedNonAlphaNumericChars(objectName.getDomain(), result);
        result.append('.');
        ArrayList<String> keys = Collections.list(objectName.getKeyPropertyList().keys());
        Collections.sort(keys);
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            StringUtils2.appendEscapedNonAlphaNumericChars(key, result);
            result.append("__");
            StringUtils2.appendEscapedNonAlphaNumericChars(objectName.getKeyProperty(key), result);
            if (!it.hasNext()) continue;
            result.append('.');
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.log(Level.FINEST, "escapeObjectName(" + objectName + "): " + result);
        }
        return result.toString();
    }

    public ExpressionLanguageEngine getExpressionLanguageEngine() {
        return this.expressionLanguageEngine;
    }

    public void setExpressionLanguageEngine(ExpressionLanguageEngine expressionLanguageEngine) {
        this.expressionLanguageEngine = expressionLanguageEngine;
    }

    @Override
    public void postConstruct(@Nonnull Map<String, String> settings) {
    }
}

