/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Tag {
    private final String name;
    private final String value;
    private final String separator;

    public Tag(String name, String value) {
        this.name = Objects.requireNonNull(name);
        this.value = Objects.requireNonNull(value);
        this.separator = ":";
    }

    public Tag(String name, String value, String separator) {
        this.name = Objects.requireNonNull(name);
        this.value = Objects.requireNonNull(value);
        this.separator = Objects.requireNonNull(separator);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getSeparator() {
        return this.separator;
    }

    public String toTagFormat() {
        return this.name + this.separator + this.value;
    }

    public String toString() {
        return this.name + this.separator + this.value;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Tag other = (Tag)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.value, other.value);
    }

    public static List<Tag> tagsFromCommaSeparatedString(String s) {
        String[] parts;
        ArrayList<Tag> tags = new ArrayList<Tag>();
        if (s.trim().isEmpty()) {
            return tags;
        }
        for (String tagPart : parts = s.split(",")) {
            tags.add(Tag.parseOneTag(tagPart));
        }
        return tags;
    }

    public static List<Tag> tagsFromCommaSeparatedString(String s, String separator) {
        String[] parts;
        ArrayList<Tag> tags = new ArrayList<Tag>();
        if (s.trim().isEmpty()) {
            return tags;
        }
        for (String tagPart : parts = s.split(",")) {
            tags.add(Tag.parseOneTag(tagPart, separator));
        }
        return tags;
    }

    private static Tag parseOneTag(String part) {
        String[] nameAndValue = part.trim().split(":");
        if (nameAndValue.length != 2) {
            throw new RuntimeException("Error when parsing tags from substring " + part + ", must be on format <name>:<value>,...");
        }
        Tag tag = new Tag(nameAndValue[0].trim(), Tag.getValueProperties(nameAndValue[1].trim()));
        return tag;
    }

    private static Tag parseOneTag(String part, String separator) {
        String[] nameAndValue = part.trim().split(separator);
        if (nameAndValue.length != 2) {
            throw new RuntimeException("Error when parsing influx from substring " + part + ", must be on format <name" + separator + "<value>,...");
        }
        Tag tag = new Tag(nameAndValue[0].trim(), Tag.getValueProperties(nameAndValue[1].trim()), separator);
        return tag;
    }

    public static List<String> convertTagsToStrings(List<Tag> tags) {
        ArrayList<String> l = new ArrayList<String>(tags.size());
        for (Tag taglist : tags) {
            l.add(taglist.toTagFormat());
        }
        return l;
    }

    private static String getValueProperties(String value) {
        String env = System.getenv(value);
        if (env == null) {
            return value;
        }
        return env;
    }
}

