/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent.google;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jmxtrans.agent.google.ApiFacade;
import org.jmxtrans.agent.util.StringUtils2;
import org.jmxtrans.agent.util.logging.Logger;

public class MetricWriter {
    private static final String[] SET_VALUES = new String[]{"projectid", "serviceaccount", "serviceaccountkey", "applicationcredentials", "separator", "nameprefix", "hostname"};
    private static final Set<String> RESERVED_KEYWORDS = new HashSet<String>(Arrays.asList(SET_VALUES));
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private SimpleDateFormat rfc3339 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'");
    private String separator;
    private String namePrefix = "";
    private Map<String, String> staticLabels = new LinkedHashMap<String, String>();
    private Map<String, String> metricDescriptors = new HashMap<String, String>();
    private String cumulativePeriodStart;

    static MetricWriter getMetricWriter(@Nonnull Map<String, String> settings) {
        MetricWriter writer = new MetricWriter();
        if (writer.init(settings)) {
            return writer;
        }
        return null;
    }

    private boolean init(@Nonnull Map<String, String> settings) {
        this.rfc3339.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.cumulativePeriodStart = this.getNow();
        String projectId = StringUtils2.trimToEmpty(settings.get("projectId"));
        if (StringUtils2.isNullOrEmpty(projectId)) {
            this.logger.info("Metrics Project ID is not set. Attempting to source project id from GKE.");
            projectId = this.getGoogleProjectId();
        }
        if (StringUtils2.isNullOrEmpty(projectId)) {
            this.logger.log(Level.WARNING, "Metrics Project ID is not set. Metric Collection agent stopped.");
            return false;
        }
        this.logger.info("Metrics GCP Project : " + projectId);
        String applicationCredentials = StringUtils2.trimToEmpty(settings.get("applicationCredentials"));
        String serviceAccount = StringUtils2.trimToEmpty(settings.get("serviceAccount"));
        String serviceAccountKey = StringUtils2.trimToEmpty(settings.get("serviceAccountKey"));
        String separator = StringUtils2.trimToEmpty(settings.get("separator"));
        this.separator = StringUtils2.isNullOrEmpty(separator) ? ":" : separator;
        String namePrefix = StringUtils2.trimToEmpty(settings.get("namePrefix"));
        this.namePrefix = StringUtils2.isNullOrEmpty(namePrefix) ? "" : namePrefix;
        this.initStaticLabels(settings);
        return ApiFacade.initConnection(projectId, serviceAccount, serviceAccountKey, applicationCredentials);
    }

    private String getNow() {
        return this.rfc3339.format(new Date());
    }

    private void initStaticLabels(Map<String, String> settings) {
        String hostname = StringUtils2.trimToEmpty(settings.get("hostname"));
        if (StringUtils2.isNullOrEmpty(hostname)) {
            hostname = System.getenv("HOSTNAME");
        }
        this.logger.info("Metrics HOSTNAME : " + hostname);
        this.staticLabels.put("hostname", hostname);
        for (Map.Entry<String, String> entry : settings.entrySet()) {
            String value = StringUtils2.trimToEmpty(settings.get(entry.getKey()));
            if (StringUtils2.isNullOrEmpty(value) || RESERVED_KEYWORDS.contains(entry.getKey().toLowerCase().trim())) continue;
            this.staticLabels.put(entry.getKey(), value);
            this.logger.log(Level.INFO, "Static label : " + entry.getKey() + " : " + value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getGoogleProjectId() {
        BufferedReader in = null;
        try {
            URLConnection yc = new URL("http://metadata.google.internal/computeMetadata/v1/project/project-id").openConnection();
            yc.setRequestProperty("Metadata-Flavor", "Google");
            in = new BufferedReader(new InputStreamReader(yc.getInputStream(), "UTF-8"));
            String string = in.readLine();
            return string;
        }
        catch (Exception e) {
            this.logger.log(Level.INFO, "Failed to source project id from GCP. Do we run in GCP? ", e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public void writeQueryResult(@Nonnull String name, @Nullable String type, @Nullable Object value) {
        LinkedHashMap<String, String> classificationLabels = new LinkedHashMap<String, String>();
        classificationLabels.putAll(Collections.unmodifiableMap(this.staticLabels));
        String[] nameParts = name.split(this.separator);
        String metricName = nameParts[0];
        for (int i = 1; i < nameParts.length; ++i) {
            classificationLabels.put("attribute_" + i, nameParts[i]);
        }
        String metricKind = this.metricDescriptors.get(metricName);
        if (null == metricKind) {
            metricKind = this.initMetricDescriptor(metricName, type, value, classificationLabels);
            this.metricDescriptors.put(metricName, metricKind);
        }
        if (!metricKind.equalsIgnoreCase("FAIL")) {
            this.writeValue(metricName, value, classificationLabels);
        }
    }

    private void writeValue(@Nonnull String metricName, @Nonnull Object value, @Nonnull Map<String, String> classificationLabels) {
        String fullMetricName = this.namePrefix + metricName;
        String endTimeString = this.getNow();
        this.logger.log(Level.FINER, fullMetricName + " : " + endTimeString + " : " + value.toString() + " : " + classificationLabels.toString());
        if (this.metricDescriptors.get(metricName).equalsIgnoreCase("GAUGE")) {
            ApiFacade.uploadMetric(fullMetricName, endTimeString, endTimeString, value, classificationLabels);
        }
        if (this.metricDescriptors.get(metricName).equalsIgnoreCase("CUMULATIVE")) {
            ApiFacade.uploadMetric(fullMetricName, this.cumulativePeriodStart, endTimeString, value, classificationLabels);
        }
    }

    private String initMetricDescriptor(String metricName, String type, Object value, HashMap<String, String> classificationLabels) {
        String metricUnit;
        String metricKind;
        ArrayList<String> labels = new ArrayList<String>();
        String fullMetricName = this.namePrefix + metricName;
        String valueType = null;
        if (!StringUtils2.isNullOrEmpty(type)) {
            String[] typeParts = type.split(this.separator);
            metricKind = typeParts[0];
            metricUnit = typeParts.length > 1 ? typeParts[1] : "1";
            if (typeParts.length > 2) {
                valueType = typeParts[2];
            }
        } else {
            metricKind = "GAUGE";
            metricUnit = "1";
        }
        if (null == valueType) {
            valueType = MetricWriter.selectValueType(value);
        }
        for (Map.Entry<String, String> entry : classificationLabels.entrySet()) {
            String key = entry.getKey();
            labels.add(key);
        }
        return ApiFacade.initCustomMetricDescriptor(fullMetricName, metricKind, metricUnit, valueType, labels);
    }

    private static String selectValueType(Object value) {
        if (value instanceof Double || value instanceof Float) {
            return "DOUBLE";
        }
        if (value instanceof Long || value instanceof Integer) {
            return "INT64";
        }
        if (value instanceof Boolean) {
            return "BOOL";
        }
        return "STRING";
    }
}

