/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent.influxdb;

import java.util.ArrayList;
import java.util.List;
import org.jmxtrans.agent.influxdb.InfluxMetric;
import org.jmxtrans.agent.influxdb.InfluxTag;

public class InfluxMetricConverter {
    public static InfluxMetric convertToInfluxMetric(String metricName, Object value, List<InfluxTag> additionalTags, long timestamp) {
        List<InfluxTag> tagsFromMetricName = InfluxMetricConverter.parseTags(metricName);
        ArrayList<InfluxTag> allTags = new ArrayList<InfluxTag>(additionalTags);
        allTags.addAll(tagsFromMetricName);
        return new InfluxMetric(InfluxMetricConverter.parseMeasurement(metricName), allTags, value, timestamp);
    }

    private static String parseMeasurement(String metricName) {
        return metricName.split(",")[0].trim();
    }

    private static List<InfluxTag> parseTags(String metricName) {
        int startOfTags = metricName.indexOf(44);
        if (startOfTags < 0) {
            return new ArrayList<InfluxTag>();
        }
        return InfluxMetricConverter.tagsFromCommaSeparatedString(metricName.substring(startOfTags + 1));
    }

    public static List<InfluxTag> tagsFromCommaSeparatedString(String s) {
        String[] parts;
        ArrayList<InfluxTag> tags = new ArrayList<InfluxTag>();
        if (s.trim().isEmpty()) {
            return tags;
        }
        for (String tagPart : parts = s.split(",")) {
            tags.add(InfluxMetricConverter.parseOneTag(tagPart));
        }
        return tags;
    }

    private static InfluxTag parseOneTag(String part) {
        String[] nameAndValue = part.trim().split("=");
        if (nameAndValue.length != 2) {
            throw new FailedToConvertToInfluxMetricException("Error when parsing influx tags from substring " + part + ", must be on format <name>=<value>,...");
        }
        InfluxTag tag = new InfluxTag(nameAndValue[0].trim(), nameAndValue[1].trim());
        return tag;
    }

    public static class FailedToConvertToInfluxMetricException
    extends RuntimeException {
        public FailedToConvertToInfluxMetricException(String msg) {
            super(msg);
        }
    }
}

