/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent.influxdb;

import java.util.Objects;

public class InfluxTag {
    private final String name;
    private final String value;

    public InfluxTag(String name, String value) {
        this.name = Objects.requireNonNull(name);
        this.value = Objects.requireNonNull(value);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String toInfluxFormat() {
        return this.name + "=" + this.value;
    }

    public String toString() {
        return this.name + "=" + this.value;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InfluxTag other = (InfluxTag)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.value, other.value);
    }
}

