/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class PropertyPlaceholderResolver
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, String> externalProperties;

    public PropertyPlaceholderResolver(Map<String, String> externalProperties) {
        this.externalProperties = Objects.requireNonNull(externalProperties);
    }

    public PropertyPlaceholderResolver() {
        this(new HashMap<String, String>());
    }

    public String resolveString(String string) throws IllegalStateException {
        StringBuilder result = new StringBuilder(string.length());
        int position = 0;
        while (position < string.length()) {
            char c = string.charAt(position);
            if (c == '$' && position < string.length() - 1 && string.charAt(position + 1) == '{') {
                String defaultValue;
                String placeholder;
                int beginningBracketPosition = position + 1;
                int endingBracketPosition = string.indexOf(125, beginningBracketPosition);
                int colonPosition = string.indexOf(58, beginningBracketPosition);
                if (colonPosition > endingBracketPosition) {
                    colonPosition = -1;
                }
                if (colonPosition == -1) {
                    placeholder = string.substring(beginningBracketPosition + 1, endingBracketPosition);
                    defaultValue = null;
                } else {
                    placeholder = string.substring(beginningBracketPosition + 1, colonPosition);
                    defaultValue = string.substring(colonPosition + 1, endingBracketPosition);
                }
                String resolvedPlaceHolder = this.resolvePlaceholder(placeholder, defaultValue);
                result.append(resolvedPlaceHolder);
                position = endingBracketPosition + 1;
                continue;
            }
            result.append(c);
            ++position;
        }
        return result.toString();
    }

    protected String resolvePlaceholder(String property, String defaultValue) throws IllegalStateException {
        String result;
        String environmentVariableStyleProperty = property.toUpperCase();
        environmentVariableStyleProperty = environmentVariableStyleProperty.replaceAll("\\.", "_");
        if (this.externalProperties.containsKey(property)) {
            result = this.externalProperties.get(property);
        } else if (System.getProperties().containsKey(property)) {
            result = System.getProperty(property);
        } else if (System.getenv().containsKey(property)) {
            result = System.getenv(property);
        } else if (System.getenv().containsKey(environmentVariableStyleProperty)) {
            result = System.getenv(environmentVariableStyleProperty);
        } else if (defaultValue != null) {
            result = defaultValue;
        } else {
            throw new IllegalStateException("Property '" + property + "' not found in System properties nor in Environment variables");
        }
        return result;
    }
}

