/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent.util.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javax.annotation.Nonnull;
import org.jmxtrans.agent.util.Preconditions2;
import org.jmxtrans.agent.util.io.AbstractResource;
import org.jmxtrans.agent.util.io.FileNotFoundRuntimeException;
import org.jmxtrans.agent.util.io.IoRuntimeException;
import org.jmxtrans.agent.util.io.Resource;

public class FileResource
extends AbstractResource
implements Resource {
    private final File file;

    public FileResource(File file) {
        Preconditions2.checkNotNull(file, "Given file cannot be null");
        this.file = file;
    }

    public FileResource(String filePath) {
        Preconditions2.checkNotNull(filePath, "Given filePath cannot be null");
        if (filePath.startsWith("file://")) {
            filePath = filePath.substring("file://".length());
        }
        this.file = new File(filePath);
    }

    @Override
    @Nonnull
    public File getFile() {
        return this.file;
    }

    @Override
    @Nonnull
    public InputStream getInputStream() {
        try {
            return new FileInputStream(this.getFile());
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundRuntimeException(e);
        }
    }

    @Override
    @Nonnull
    public URL getURL() {
        try {
            return this.getURI().toURL();
        }
        catch (MalformedURLException e) {
            throw IoRuntimeException.propagate(e);
        }
    }

    @Override
    @Nonnull
    public URI getURI() {
        return this.getFile().toURI();
    }

    @Override
    public String getDescription() {
        return "File resource: " + this.file;
    }
}

