/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import org.jmxtrans.agent.AbstractOutputWriter;
import org.jmxtrans.agent.OutputWriter;
import org.jmxtrans.agent.Tag;
import org.jmxtrans.agent.util.CachingReference;
import org.jmxtrans.agent.util.ConfigurationUtils;
import org.jmxtrans.agent.util.StringUtils2;

public class StatsDOutputWriter
extends AbstractOutputWriter
implements OutputWriter {
    public static final String SETTING_HOST = "host";
    public static final String SETTING_PORT = "port";
    public static final String SETTING_ROOT_PREFIX = "metricName";
    public static final String SETTING_HOST_NAMME = "hostname";
    public static final String SETTING_BUFFER_SIZE = "bufferSize";
    private static final int SETTING_DEFAULT_BUFFER_SIZE = 1024;
    public static final String SETTINGS_STATSD_TYPE = "statsd";
    public static final String STATSD_DATADOG = "dd";
    public static final String STATSD_SYSDIG = "sysdig";
    public static final String SETTINGS_TAGS = "tags";
    private List<Tag> tags;
    private ByteBuffer sendBuffer;
    private String metricNamePrefix;
    private String statsType;
    private CachingReference<InetSocketAddress> addressReference;
    private DatagramChannel channel;

    @Override
    public synchronized void postConstruct(Map<String, String> settings) {
        String tagsStr;
        super.postConstruct(settings);
        final String host = ConfigurationUtils.getString(settings, SETTING_HOST);
        final Integer port = ConfigurationUtils.getInt(settings, SETTING_PORT);
        this.statsType = ConfigurationUtils.getString(settings, SETTINGS_STATSD_TYPE, SETTINGS_STATSD_TYPE);
        if (this.statsType.equals(STATSD_DATADOG)) {
            tagsStr = ConfigurationUtils.getString(settings, SETTINGS_TAGS, "");
            this.tags = Tag.tagsFromCommaSeparatedString(tagsStr);
            this.tags.add(new Tag(SETTING_HOST, ConfigurationUtils.getString(settings, SETTING_HOST_NAMME, this.getHostName().replaceAll("\\.", "_"))));
            this.metricNamePrefix = ConfigurationUtils.getString(settings, SETTING_ROOT_PREFIX, "java");
        } else if (this.statsType.equals(STATSD_SYSDIG)) {
            tagsStr = ConfigurationUtils.getString(settings, SETTINGS_TAGS, "");
            this.tags = Tag.tagsFromCommaSeparatedString(tagsStr, "=");
            this.metricNamePrefix = ConfigurationUtils.getString(settings, SETTING_ROOT_PREFIX, this.getHostName().replaceAll("\\.", "_"));
        } else {
            this.metricNamePrefix = ConfigurationUtils.getString(settings, SETTING_ROOT_PREFIX, this.getHostName().replaceAll("\\.", "_"));
        }
        if (port == null || StringUtils2.isNullOrEmpty(host)) {
            throw new RuntimeException("Host and/or port cannot be null");
        }
        int bufferSize = ConfigurationUtils.getInt(settings, SETTING_BUFFER_SIZE, 1024);
        this.sendBuffer = ByteBuffer.allocate(bufferSize);
        this.addressReference = new CachingReference<InetSocketAddress>(30L, TimeUnit.SECONDS){

            @Override
            @Nonnull
            protected InetSocketAddress newObject() {
                return new InetSocketAddress(host, (int)port);
            }
        };
        try {
            this.channel = DatagramChannel.open();
        }
        catch (IOException e) {
            throw new RuntimeException("Exception opening datagram channel", e);
        }
        this.logger.info(String.format("StatsDOutputWriter[host=%s, port=%d, metricNamePrefix=%s]", host, port, this.metricNamePrefix));
    }

    protected String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            try {
                return InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e1) {
                return "unknown.host";
            }
        }
    }

    @Override
    public void postCollect() throws IOException {
        this.flush();
    }

    @Override
    public void writeInvocationResult(String invocationName, Object value) throws IOException {
        this.writeQueryResult(invocationName, null, value);
    }

    @Override
    public synchronized void writeQueryResult(String metricName, String metricType, Object value) throws IOException {
        String type;
        StringBuilder sb = new StringBuilder();
        String string = type = "gauge".equalsIgnoreCase(metricType) || "g".equalsIgnoreCase(metricType) ? "g" : "c";
        if (this.statsType.equals(STATSD_DATADOG)) {
            sb.append(this.metricNamePrefix).append(".").append(metricName).append(":").append(value).append("|").append(type).append("|#").append(StringUtils2.join(Tag.convertTagsToStrings(this.tags), ",")).append("\n");
        } else if (this.statsType.equals(STATSD_SYSDIG)) {
            sb.append(this.metricNamePrefix).append(".").append(metricName).append("#").append(StringUtils2.join(Tag.convertTagsToStrings(this.tags), ",")).append(":").append(value).append("|").append(type).append("\n");
        } else {
            sb.append(this.metricNamePrefix).append(".").append(metricName).append(":").append(value).append("|").append(type).append("\n");
        }
        if (this.logger.isLoggable(this.getDebugLevel())) {
            this.logger.log(this.getDebugLevel(), "Sending msg: " + sb.toString());
        }
        this.doSend(sb.toString());
    }

    protected synchronized boolean doSend(String stat) {
        try {
            byte[] data = stat.getBytes("utf-8");
            if (this.sendBuffer.remaining() < data.length + 1) {
                this.flush();
            }
            if (this.sendBuffer.remaining() < data.length + 1) {
                this.logger.warning("Given data too big (" + data.length + "bytes) for the buffer size (" + this.sendBuffer.remaining() + "bytes), skip it: " + StringUtils2.abbreviate(stat, 20));
            }
            this.sendBuffer.put(data);
            return true;
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, String.format("Could not send stat %s to host %s:%d", this.sendBuffer.toString(), this.addressReference.get().getHostName(), this.addressReference.get().getPort()), e);
            return false;
        }
    }

    public synchronized boolean flush() {
        InetSocketAddress address = this.addressReference.get();
        try {
            int sizeOfBuffer = this.sendBuffer.position();
            if (sizeOfBuffer <= 0) {
                return false;
            }
            this.sendBuffer.flip();
            int nbSentBytes = this.channel.send(this.sendBuffer, address);
            this.sendBuffer.limit(this.sendBuffer.capacity());
            this.sendBuffer.rewind();
            if (sizeOfBuffer == nbSentBytes) {
                return true;
            }
            this.logger.log(Level.SEVERE, String.format("Could not send entirely stat %s to host %s:%d. Only sent %d bytes out of %d bytes", this.sendBuffer.toString(), address.getHostName(), address.getPort(), nbSentBytes, sizeOfBuffer));
            return false;
        }
        catch (IOException | RuntimeException e) {
            this.addressReference.purge();
            this.logger.log(Level.SEVERE, String.format("Could not send stat %s to host %s:%d", this.sendBuffer.toString(), address.getHostName(), address.getPort()), e);
            this.sendBuffer.clear();
            return false;
        }
    }
}

