/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent.util.io;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.annotation.Nonnull;
import org.jmxtrans.agent.util.io.FileNotFoundRuntimeException;
import org.jmxtrans.agent.util.io.IoRuntimeException;
import org.jmxtrans.agent.util.io.Resource;

public abstract class AbstractResource
implements Resource {
    @Override
    public long lastModified() throws IoRuntimeException {
        long lastModified = this.getFile().lastModified();
        if (lastModified == 0L) {
            throw new FileNotFoundRuntimeException(this.getDescription() + " cannot be resolved in the file system for resolving its last-modified timestamp");
        }
        return lastModified;
    }

    @Override
    @Nonnull
    public URL getURL() throws IoRuntimeException {
        throw new FileNotFoundRuntimeException(this.getDescription() + " cannot be resolved to URL");
    }

    @Override
    @Nonnull
    public File getFile() throws IoRuntimeException {
        throw new FileNotFoundRuntimeException(this.getDescription() + " cannot be resolved to absolute file path");
    }

    @Override
    @Nonnull
    public URI getURI() throws IoRuntimeException {
        URL url = this.getURL();
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new IoRuntimeException("Exception parsing the URI of '" + url + "'", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean exists() {
        try {
            return this.getFile().exists();
        }
        catch (IoRuntimeException ex) {
            try (InputStream is = this.getInputStream();){
                boolean bl = true;
                return bl;
            }
            catch (Throwable isEx) {
                return false;
            }
        }
    }

    public String toString() {
        return this.getDescription();
    }
}

