/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent.zabbix;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jmxtrans.agent.AbstractOutputWriter;
import org.jmxtrans.agent.OutputWriter;
import org.jmxtrans.agent.util.ConfigurationUtils;
import org.jmxtrans.agent.util.io.IoUtils;
import org.jmxtrans.agent.util.net.HostAndPort;
import org.jmxtrans.agent.zabbix.ZabbixMetricMessageBuilder;
import org.jmxtrans.agent.zabbix.ZabbixOutputWriterCommonSettings;

public class ZabbixTcpOutputWriter
extends AbstractOutputWriter
implements OutputWriter {
    private static final int ZABBIX_HEADER_LENGTH = 13;
    public static final String SETTING_SOCKET_CONNECT_TIMEOUT_IN_MILLIS = "socket.connectTimeoutInMillis";
    public static final int SETTING_SOCKET_CONNECT_TIMEOUT_IN_MILLIS_DEFAULT_VALUE = 500;
    protected HostAndPort zabbixServerHostAndPort;
    private Socket socket;
    private ByteArrayOutputStream out = new ByteArrayOutputStream();
    private byte[] readBuffer = new byte[10000];
    private int socketConnectTimeoutInMillis = 500;
    private ZabbixMetricMessageBuilder messageBuilder;
    private int printMetricCount = 0;
    private int metricBatchSize;
    private boolean failedConnection = false;
    private byte[] messageHeader = "{\"request\":\"sender data\",\"data\":[".getBytes(StandardCharsets.UTF_8);
    private byte[] comma = ",".getBytes(StandardCharsets.UTF_8);
    private byte[] messageFooter = "]}".getBytes(StandardCharsets.UTF_8);

    @Override
    public void postConstruct(Map<String, String> settings) {
        super.postConstruct(settings);
        this.zabbixServerHostAndPort = new HostAndPort(ConfigurationUtils.getString(settings, "host"), ConfigurationUtils.getInt(settings, "port", 2003));
        this.messageBuilder = new ZabbixMetricMessageBuilder(ZabbixOutputWriterCommonSettings.getConfiguredHostName(settings));
        this.socketConnectTimeoutInMillis = ConfigurationUtils.getInt(settings, SETTING_SOCKET_CONNECT_TIMEOUT_IN_MILLIS, 500);
        this.metricBatchSize = ZabbixOutputWriterCommonSettings.getMetricBatchSize(settings);
        this.logger.log(this.getInfoLevel(), "ZabbixTcpOutputWriter is configured with " + this.zabbixServerHostAndPort + ", serverName=" + this.messageBuilder.getHostName() + ", socketConnectTimeoutInMillis=" + this.socketConnectTimeoutInMillis + ", metricBatchSize=" + this.metricBatchSize);
    }

    @Override
    public void writeInvocationResult(@Nonnull String invocationName, @Nullable Object value) throws IOException {
        this.writeQueryResult(invocationName, null, value);
    }

    @Override
    public void writeQueryResult(@Nonnull String metricName, @Nullable String type, @Nullable Object value) throws IOException {
        String msg = this.messageBuilder.buildMessage(metricName, value, TimeUnit.SECONDS.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS));
        try {
            if (this.logger.isLoggable(this.getTraceLevel())) {
                this.logger.log(this.getTraceLevel(), "Send '" + msg + "' to " + this.zabbixServerHostAndPort);
            }
            if (this.printMetricCount == 0) {
                this.writeMessage(this.messageHeader);
            } else {
                this.writeMessage(this.comma);
            }
            ++this.printMetricCount;
            this.writeMessage(msg);
            if (this.printMetricCount >= this.metricBatchSize) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("Reached batch size maximum of " + this.metricBatchSize + " .Forcing message output to Zabbix.");
                }
                this.postCollect();
            }
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "Exception sending '" + msg + "' of size : " + this.out.size() + "bytes to " + this.zabbixServerHostAndPort, e);
            this.releaseZabbixConnection();
            throw e;
        }
    }

    private void writeMessage(String msg) throws IOException {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("Print : " + msg);
        }
        byte[] bytes = msg.getBytes(StandardCharsets.UTF_8);
        this.writeMessage(bytes);
    }

    protected void writeMessage(byte[] data) throws IOException {
        this.out.write(data);
    }

    private void writeZabbixHeader(int length) throws IOException {
        byte[] zabbixHeader = new byte[]{90, 66, 88, 68, 1, (byte)(length & 0xFF), (byte)(length >> 8 & 0xFF), (byte)(length >> 16 & 0xFF), (byte)(length >> 24 & 0xFF), 0, 0, 0, 0};
        this.socket.getOutputStream().write(zabbixHeader);
    }

    private void releaseZabbixConnection() {
        IoUtils.closeQuietly(this.out);
        IoUtils.closeQuietly(this.socket);
    }

    private void ensureZabbixConnection() throws IOException {
        boolean socketIsValid;
        try {
            socketIsValid = this.socket != null && this.socket.isConnected() && this.socket.isBound() && !this.socket.isClosed() && !this.socket.isInputShutdown() && !this.socket.isOutputShutdown();
        }
        catch (Exception e) {
            socketIsValid = false;
        }
        if (!socketIsValid) {
            long start = System.currentTimeMillis();
            try {
                this.socket = new Socket();
                this.socket.setKeepAlive(true);
                this.socket.connect(new InetSocketAddress(this.zabbixServerHostAndPort.getHost(), this.zabbixServerHostAndPort.getPort()), this.socketConnectTimeoutInMillis);
            }
            catch (IOException e) {
                ConnectException ce = new ConnectException("Exception connecting to " + this.zabbixServerHostAndPort);
                ce.initCause(e);
                throw ce;
            }
            long end = System.currentTimeMillis();
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Connect time : " + (end - start));
            }
        }
    }

    @Override
    public void postCollect() throws IOException {
        if (this.printMetricCount == 0) {
            return;
        }
        try {
            this.writeMessage(this.messageFooter);
            byte[] byteArray = this.out.toByteArray();
            this.out.reset();
            if (this.logger.isLoggable(Level.FINEST)) {
                String msg = new String(byteArray, StandardCharsets.UTF_8);
                this.logger.finest("message : " + msg);
            }
            this.ensureZabbixConnection();
            this.writeZabbixHeader(byteArray.length);
            this.socket.getOutputStream().write(byteArray);
            this.printMetricCount = 0;
            this.drainInputStream();
            this.releaseZabbixConnection();
            this.failedConnection = false;
        }
        catch (IOException e) {
            if (this.failedConnection) {
                this.logger.log(Level.FINE, "Exception flushing the stream to " + this.zabbixServerHostAndPort, e);
            } else {
                this.logger.log(Level.WARNING, "Exception flushing the stream to " + this.zabbixServerHostAndPort, e);
            }
            this.releaseZabbixConnection();
            throw e;
        }
    }

    private void drainInputStream() throws IOException {
        try {
            int readSize = this.socket.getInputStream().read(this.readBuffer);
            if (this.logger.isLoggable(Level.FINE)) {
                String message = this.extractZabbixResponseString(readSize, this.readBuffer);
                this.logger.log(Level.FINE, message);
            }
        }
        catch (Exception ex) {
            this.logger.log(Level.WARNING, "Failed to read from scoket " + this.zabbixServerHostAndPort, ex);
        }
    }

    private String extractZabbixResponseString(int readSize, byte[] buffer) {
        String msg = "";
        if (readSize > 13) {
            msg = new String(buffer, 13, readSize - 13, StandardCharsets.UTF_8);
        }
        return msg;
    }

    public String toString() {
        return "ZabbixTcpOutputWriter{, " + this.zabbixServerHostAndPort + ", serverName='" + this.messageBuilder.getHostName() + '\'' + '}';
    }

    @Override
    public void preDestroy() {
        super.preDestroy();
        this.releaseZabbixConnection();
    }
}

