/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.embedded.output;

import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectName;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.jmxtrans.embedded.QueryResult;
import org.jmxtrans.embedded.output.AbstractOutputWriter;
import org.jmxtrans.embedded.output.OutputWriter;
import org.jmxtrans.embedded.util.jmx.JmxUtils2;
import org.jmxtrans.embedded.util.net.SocketWriter;
import org.jmxtrans.embedded.util.pool.ManagedGenericKeyedObjectPool;
import org.jmxtrans.embedded.util.pool.SocketWriterPoolFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphiteWriter
extends AbstractOutputWriter
implements OutputWriter {
    public static final int DEFAULT_GRAPHITE_SERVER_PORT = 2003;
    public static final String DEFAULT_NAME_PREFIX = "servers.#hostname#.";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String metricPathPrefix;
    private InetSocketAddress graphiteServerSocketAddress;
    private ManagedGenericKeyedObjectPool<InetSocketAddress, SocketWriter> socketWriterPool;
    private ObjectName socketPoolObjectName;

    @Override
    public void start() {
        int port = this.getIntSetting("port", 2003);
        String host = this.getStringSetting("host");
        this.graphiteServerSocketAddress = new InetSocketAddress(host, port);
        this.logger.info("Start Graphite writer connected to '{}'...", (Object)this.graphiteServerSocketAddress);
        this.metricPathPrefix = this.getStringSetting("namePrefix", DEFAULT_NAME_PREFIX);
        this.metricPathPrefix = this.getStrategy().resolveExpression(this.metricPathPrefix);
        if (!this.metricPathPrefix.isEmpty() && !this.metricPathPrefix.endsWith(".")) {
            this.metricPathPrefix = this.metricPathPrefix + ".";
        }
        GenericKeyedObjectPool.Config config = new GenericKeyedObjectPool.Config();
        config.testOnBorrow = this.getBooleanSetting("pool.testOnBorrow", true);
        config.testWhileIdle = this.getBooleanSetting("pool.testWhileIdle", true);
        config.maxActive = this.getIntSetting("pool.maxActive", -1);
        config.maxIdle = this.getIntSetting("pool.maxIdle", -1);
        config.minEvictableIdleTimeMillis = this.getLongSetting("pool.minEvictableIdleTimeMillis", TimeUnit.MINUTES.toMillis(5L));
        config.timeBetweenEvictionRunsMillis = this.getLongSetting("pool.timeBetweenEvictionRunsMillis", TimeUnit.MINUTES.toMillis(5L));
        this.socketWriterPool = new ManagedGenericKeyedObjectPool<InetSocketAddress, SocketWriter>(new SocketWriterPoolFactory("UTF-8"), config);
        this.socketPoolObjectName = JmxUtils2.registerObject(this.socketWriterPool, "org.jmxtrans.embedded:Type=SocketPool,Host=" + host + ",Port=" + port + ",Name=GraphiteSocketPool@" + System.identityHashCode(this), ManagementFactory.getPlatformMBeanServer());
        try {
            SocketWriter socketWriter = (SocketWriter)this.socketWriterPool.borrowObject(this.graphiteServerSocketAddress);
            this.socketWriterPool.returnObject(this.graphiteServerSocketAddress, socketWriter);
        }
        catch (Exception e) {
            this.logger.warn("Graphite server '{}' connection test failure", (Throwable)e);
        }
    }

    @Override
    public void write(Iterable<QueryResult> results) {
        block5: {
            this.logger.debug("Export to '{}' results {}", (Object)this.graphiteServerSocketAddress, results);
            SocketWriter socketWriter = null;
            try {
                socketWriter = (SocketWriter)this.socketWriterPool.borrowObject(this.graphiteServerSocketAddress);
                for (QueryResult result : results) {
                    String msg = this.metricPathPrefix + result.getName() + " " + result.getValue() + " " + result.getEpoch(TimeUnit.SECONDS) + "\n";
                    this.logger.debug("Export '{}'", (Object)msg);
                    socketWriter.write(msg);
                }
                socketWriter.flush();
                this.socketWriterPool.returnObject(this.graphiteServerSocketAddress, socketWriter);
            }
            catch (Exception e) {
                this.logger.warn("Failure to send result to graphite server '{}' with {}", new Object[]{this.graphiteServerSocketAddress, socketWriter, e});
                if (socketWriter == null) break block5;
                try {
                    this.socketWriterPool.invalidateObject(this.graphiteServerSocketAddress, socketWriter);
                }
                catch (Exception e2) {
                    this.logger.warn("Exception invalidating socketWriter connected to graphite server '{}': {}", new Object[]{this.graphiteServerSocketAddress, socketWriter, e2});
                }
            }
        }
    }

    @Override
    public void stop() throws Exception {
        this.logger.info("Stop GraphiteWriter connected to '{}' ...", (Object)this.graphiteServerSocketAddress);
        super.stop();
        this.socketWriterPool.close();
        JmxUtils2.unregisterObject(this.socketPoolObjectName, ManagementFactory.getPlatformMBeanServer());
    }
}

