/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.embedded.util.pool;

import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import org.apache.commons.pool.BaseKeyedPoolableObjectFactory;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.jmxtrans.embedded.util.net.SocketWriter;

public class SocketWriterPoolFactory
extends BaseKeyedPoolableObjectFactory<InetSocketAddress, SocketWriter>
implements KeyedPoolableObjectFactory<InetSocketAddress, SocketWriter> {
    private final Charset charset;

    public SocketWriterPoolFactory(String charset) {
        this(Charset.forName(charset));
    }

    public SocketWriterPoolFactory(Charset charset) {
        this.charset = charset;
    }

    public SocketWriter makeObject(InetSocketAddress inetSocketAddress) throws Exception {
        Socket socket = new Socket(inetSocketAddress.getAddress(), inetSocketAddress.getPort());
        socket.setKeepAlive(true);
        return new SocketWriter(socket, this.charset);
    }

    public void destroyObject(InetSocketAddress inetSocketAddress, SocketWriter socketWriter) throws Exception {
        super.destroyObject((Object)inetSocketAddress, (Object)socketWriter);
        socketWriter.close();
        socketWriter.getSocket().close();
    }

    public boolean validateObject(InetSocketAddress inetSocketAddress, SocketWriter socketWriter) {
        Socket socket = socketWriter.getSocket();
        return socket.isConnected() && socket.isBound() && !socket.isClosed() && !socket.isInputShutdown() && !socket.isOutputShutdown();
    }
}

