/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.embedded;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.management.MBeanServer;
import org.jmxtrans.embedded.EmbeddedJmxTransMBean;
import org.jmxtrans.embedded.Query;
import org.jmxtrans.embedded.output.OutputWriter;
import org.jmxtrans.embedded.util.concurrent.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedJmxTrans
implements EmbeddedJmxTransMBean {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean running = false;
    private ScheduledExecutorService collectScheduledExecutor;
    private ScheduledExecutorService exportScheduledExecutor;
    @Nonnull
    private MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
    @Nonnull
    private final List<Query> queries = new ArrayList<Query>();
    private Set<OutputWriter> outputWriters = new HashSet<OutputWriter>();
    private int numQueryThreads = 1;
    private int numExportThreads = 1;
    private int queryIntervalInSeconds = 30;
    private int exportIntervalInSeconds = 5;
    private int exportBatchSize = 50;
    private EmbeddedJmxTransShutdownHook shutdownHook = new EmbeddedJmxTransShutdownHook();

    public EmbeddedJmxTrans() {
    }

    public EmbeddedJmxTrans(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    @PostConstruct
    public synchronized void start() throws Exception {
        if (this.running) {
            this.logger.debug("Ignore start() command for already running instance");
            return;
        }
        for (final Query query : this.queries) {
            query.start();
        }
        for (OutputWriter outputWriter : this.outputWriters) {
            outputWriter.start();
        }
        this.collectScheduledExecutor = Executors.newScheduledThreadPool(this.getNumQueryThreads(), new NamedThreadFactory("jmxtrans-collect-", true));
        this.exportScheduledExecutor = Executors.newScheduledThreadPool(this.getNumExportThreads(), new NamedThreadFactory("jmxtrans-export-", true));
        for (final Query query : this.getQueries()) {
            this.collectScheduledExecutor.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    query.collectMetrics();
                }
            }, 0L, this.getQueryIntervalInSeconds(), TimeUnit.SECONDS);
            this.exportScheduledExecutor.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    query.exportCollectedMetrics();
                }
            }, this.getQueryIntervalInSeconds() + 1, this.getExportIntervalInSeconds(), TimeUnit.SECONDS);
        }
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        this.running = true;
        this.logger.info("EmbeddedJmxTrans started");
    }

    @PreDestroy
    public synchronized void stop() throws Exception {
        if (!this.running) {
            this.logger.debug("Ignore stop() command for not running instance");
            return;
        }
        this.collectScheduledExecutor.shutdown();
        try {
            this.collectScheduledExecutor.awaitTermination(this.getQueryIntervalInSeconds(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.logger.warn("Ignore InterruptedException stopping", (Throwable)e);
        }
        this.exportScheduledExecutor.shutdown();
        try {
            this.exportScheduledExecutor.awaitTermination(this.getExportIntervalInSeconds(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.logger.warn("Ignore InterruptedException stopping", (Throwable)e);
        }
        this.collectMetrics();
        this.exportCollectedMetrics();
        for (Query query : this.queries) {
            query.stop();
        }
        for (OutputWriter outputWriter : this.outputWriters) {
            outputWriter.stop();
        }
        this.logger.info("EmbeddedJmxTrans stopped. Metrics have been collected and exported one last time.");
        boolean shutdownHookRemoved = Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        if (shutdownHookRemoved) {
            this.logger.debug("ShutdownHook successfully removed");
        } else {
            this.logger.warn("Failure to remove ShutdownHook");
        }
        this.running = false;
    }

    @Override
    public void collectMetrics() {
        for (Query query : this.getQueries()) {
            query.collectMetrics();
        }
    }

    @Override
    public void exportCollectedMetrics() {
        for (Query query : this.getQueries()) {
            query.exportCollectedMetrics();
        }
    }

    @Nonnull
    public List<Query> getQueries() {
        return this.queries;
    }

    public void addQuery(@Nonnull Query query) {
        query.setEmbeddedJmxTrans(this);
        this.queries.add(query);
    }

    public String toString() {
        return "EmbeddedJmxTrans{ queries=" + this.queries + ", outputWriters=" + this.outputWriters + ", numQueryThreads=" + this.numQueryThreads + ", queryIntervalInSeconds=" + this.queryIntervalInSeconds + ", numExportThreads=" + this.numExportThreads + ", exportIntervalInSeconds=" + this.exportIntervalInSeconds + ", exportBatchSize=" + this.exportBatchSize + '}';
    }

    @Override
    public int getNumQueryThreads() {
        return this.numQueryThreads;
    }

    public void setNumQueryThreads(int numQueryThreads) {
        this.numQueryThreads = numQueryThreads;
    }

    @Override
    public int getQueryIntervalInSeconds() {
        return this.queryIntervalInSeconds;
    }

    public void setQueryIntervalInSeconds(int queryIntervalInSeconds) {
        this.queryIntervalInSeconds = queryIntervalInSeconds;
    }

    @Override
    public int getExportIntervalInSeconds() {
        return this.exportIntervalInSeconds;
    }

    public void setExportIntervalInSeconds(int exportIntervalInSeconds) {
        this.exportIntervalInSeconds = exportIntervalInSeconds;
    }

    @Override
    public int getNumExportThreads() {
        return this.numExportThreads;
    }

    public void setNumExportThreads(int numExportThreads) {
        this.numExportThreads = numExportThreads;
    }

    @Nonnull
    public Set<OutputWriter> getOutputWriters() {
        return this.outputWriters;
    }

    public int getExportBatchSize() {
        return this.exportBatchSize;
    }

    public void setExportBatchSize(int exportBatchSize) {
        this.exportBatchSize = exportBatchSize;
    }

    @Nonnull
    public MBeanServer getMbeanServer() {
        return this.mbeanServer;
    }

    @Override
    public int getCollectedMetricsCount() {
        int result = 0;
        for (Query query : this.queries) {
            result += query.getCollectedMetricsCount();
        }
        return result;
    }

    @Override
    public long getCollectionDurationInNanos() {
        long result = 0L;
        for (Query query : this.queries) {
            result += query.getCollectionDurationInNanos();
        }
        return result;
    }

    @Override
    public long getCollectionDurationInMillis() {
        return TimeUnit.MILLISECONDS.convert(this.getCollectionDurationInNanos(), TimeUnit.NANOSECONDS);
    }

    @Override
    public int getCollectionCount() {
        int result = 0;
        for (Query query : this.queries) {
            result += query.getCollectionCount();
        }
        return result;
    }

    @Override
    public int getExportedMetricsCount() {
        int result = 0;
        for (Query query : this.queries) {
            result += query.getExportedMetricsCount();
        }
        return result;
    }

    @Override
    public long getExportDurationInNanos() {
        long result = 0L;
        for (Query query : this.queries) {
            result += query.getExportDurationInNanos();
        }
        return result;
    }

    @Override
    public long getExportDurationInMillis() {
        return TimeUnit.MILLISECONDS.convert(this.getExportDurationInNanos(), TimeUnit.NANOSECONDS);
    }

    @Override
    public int getExportCount() {
        int result = 0;
        for (Query query : this.queries) {
            result += query.getExportCount();
        }
        return result;
    }

    @Override
    public int getDiscardedResultsCount() {
        int result = 0;
        for (Query query : this.queries) {
            int discardedResultsCount = query.getDiscardedResultsCount();
            if (discardedResultsCount == -1) continue;
            result += discardedResultsCount;
        }
        return result;
    }

    private class EmbeddedJmxTransShutdownHook
    extends Thread {
        private EmbeddedJmxTransShutdownHook() {
        }

        @Override
        public void run() {
            super.run();
            EmbeddedJmxTrans.this.collectMetrics();
            EmbeddedJmxTrans.this.exportCollectedMetrics();
            EmbeddedJmxTrans.this.logger.info("EmbeddedJmxTransShutdownHook collected and exported metrics");
        }
    }
}

