/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.embedded.spring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jmxtrans.embedded.EmbeddedJmxTrans;
import org.jmxtrans.embedded.EmbeddedJmxTransException;
import org.jmxtrans.embedded.config.ConfigurationParser;
import org.jmxtrans.embedded.spring.SpringEmbeddedJmxTrans;
import org.jmxtrans.embedded.util.concurrent.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StringUtils;

public class EmbeddedJmxTransFactory
implements FactoryBean<SpringEmbeddedJmxTrans>,
BeanNameAware,
DisposableBean {
    private static final String DEFAULT_CONFIGURATION_URL = "classpath:jmxtrans.json, classpath:org/jmxtrans/embedded/config/jmxtrans-internals.json";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<String> configurationUrls;
    private SpringEmbeddedJmxTrans embeddedJmxTrans;
    private ResourceLoader resourceLoader;
    private boolean ignoreConfigurationNotFound = false;
    private String beanName = "jmxtrans";
    private long lastModified;
    private int configurationScanPeriodInSeconds = 0;
    private ScheduledExecutorService configurationReloaderExecutor;

    private long computeConfigurationLastModified(List<Resource> configurations) {
        long result = 0L;
        for (Resource configuration : configurations) {
            try {
                long currentConfigurationLastModified = configuration.lastModified();
                if (currentConfigurationLastModified <= result) continue;
                result = currentConfigurationLastModified;
            }
            catch (IOException ioex) {
                this.logger.warn("Error while reading last configuration modification date.", (Throwable)ioex);
            }
        }
        return result;
    }

    private List<Resource> getConfigurations() {
        ArrayList<Resource> result = new ArrayList<Resource>();
        for (String delimitedConfigurationUrl : this.configurationUrls) {
            String[] tokens = StringUtils.commaDelimitedListToStringArray((String)delimitedConfigurationUrl);
            for (String configurationUrl : tokens = StringUtils.trimArrayElements((String[])tokens)) {
                Resource configuration = this.resourceLoader.getResource(configurationUrl = configurationUrl.trim());
                if (configuration != null && configuration.exists()) {
                    result.add(configuration);
                    continue;
                }
                if (this.ignoreConfigurationNotFound) {
                    this.logger.debug("Ignore missing configuration file {}", (Object)configuration);
                    continue;
                }
                throw new EmbeddedJmxTransException("Configuration file " + configuration + " not found");
            }
        }
        return result;
    }

    @Autowired
    public EmbeddedJmxTransFactory(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public SpringEmbeddedJmxTrans getObject() throws Exception {
        this.logger.info("Load JmxTrans with configuration '{}'", this.configurationUrls);
        if (this.embeddedJmxTrans == null) {
            if (this.configurationUrls == null) {
                this.configurationUrls = Collections.singletonList(DEFAULT_CONFIGURATION_URL);
            }
            SpringEmbeddedJmxTrans newJmxTrans = new SpringEmbeddedJmxTrans();
            newJmxTrans.setObjectName("org.jmxtrans.embedded:type=EmbeddedJmxTrans,name=" + this.beanName);
            List<Resource> configurations = this.getConfigurations();
            this.loadConfiguration(newJmxTrans, configurations);
            this.lastModified = this.computeConfigurationLastModified(configurations);
            this.embeddedJmxTrans = newJmxTrans;
            this.logger.info("Created EmbeddedJmxTrans with configuration {})", this.configurationUrls);
            this.embeddedJmxTrans.start();
            if (this.configurationScanPeriodInSeconds > 0) {
                this.configurationReloaderExecutor = Executors.newScheduledThreadPool(1, new NamedThreadFactory("jmxtrans-configuration-reloader-", true));
                this.configurationReloaderExecutor.scheduleWithFixedDelay(new ConfigurationReloader(), 0L, this.configurationScanPeriodInSeconds, TimeUnit.SECONDS);
                this.logger.info("Configuration reloader created. Scanning every {}s.", (Object)this.configurationScanPeriodInSeconds);
            } else {
                this.logger.info("Automatic configuration reloading is disabled.");
            }
        }
        return this.embeddedJmxTrans;
    }

    private void loadConfiguration(SpringEmbeddedJmxTrans jmxTrans, List<Resource> configurations) {
        ConfigurationParser parser = new ConfigurationParser();
        for (Resource configuration : configurations) {
            try {
                parser.mergeEmbeddedJmxTransConfiguration(configuration.getInputStream(), (EmbeddedJmxTrans)jmxTrans);
            }
            catch (Exception e) {
                throw new EmbeddedJmxTransException("Exception loading configuration " + configuration, e);
            }
        }
    }

    public void destroy() throws Exception {
        if (this.configurationReloaderExecutor != null) {
            this.logger.info("Configuration reloader shutdown.");
            this.configurationReloaderExecutor.shutdown();
        }
        if (this.embeddedJmxTrans != null) {
            this.embeddedJmxTrans.destroy();
        }
    }

    public Class<?> getObjectType() {
        return EmbeddedJmxTrans.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setConfigurationUrl(String configurationUrl) {
        if (this.configurationUrls == null) {
            this.configurationUrls = new ArrayList<String>();
        }
        this.configurationUrls.add(configurationUrl);
    }

    public void setConfigurationUrls(List<String> configurationUrls) {
        if (this.configurationUrls == null) {
            this.configurationUrls = new ArrayList<String>();
        }
        this.configurationUrls.addAll(configurationUrls);
    }

    public void setIgnoreConfigurationNotFound(boolean ignoreConfigurationNotFound) {
        this.ignoreConfigurationNotFound = ignoreConfigurationNotFound;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setConfigurationScanPeriodInSeconds(int configurationScanPeriodInSeconds) {
        this.configurationScanPeriodInSeconds = configurationScanPeriodInSeconds;
    }

    private class ConfigurationReloader
    implements Runnable {
        private ConfigurationReloader() {
        }

        @Override
        public synchronized void run() {
            EmbeddedJmxTransFactory.this.logger.debug("Check configuration last modified.");
            List configurations = EmbeddedJmxTransFactory.this.getConfigurations();
            long configurationLastModified = EmbeddedJmxTransFactory.this.computeConfigurationLastModified(configurations);
            if (EmbeddedJmxTransFactory.this.embeddedJmxTrans != null) {
                if (configurationLastModified > EmbeddedJmxTransFactory.this.lastModified) {
                    EmbeddedJmxTransFactory.this.logger.info("Configuration change detected. Reload configuration....");
                    EmbeddedJmxTransFactory.this.lastModified = configurationLastModified;
                    try {
                        EmbeddedJmxTransFactory.this.logger.debug("Stop jmxtrans....");
                        EmbeddedJmxTransFactory.this.embeddedJmxTrans.stop();
                        EmbeddedJmxTransFactory.this.embeddedJmxTrans.getQueries().clear();
                        EmbeddedJmxTransFactory.this.embeddedJmxTrans.getOutputWriters().clear();
                        EmbeddedJmxTransFactory.this.logger.debug("jmxtrans stopped. Start jmxtrans....");
                        EmbeddedJmxTransFactory.this.loadConfiguration(EmbeddedJmxTransFactory.this.embeddedJmxTrans, configurations);
                        EmbeddedJmxTransFactory.this.embeddedJmxTrans.start();
                        EmbeddedJmxTransFactory.this.logger.info("jmxtrans restarted with new configuration.");
                    }
                    catch (Exception e) {
                        EmbeddedJmxTransFactory.this.logger.error("Error while reloading the configuration. Embedded JmxTrans is disabled until the configuration is fixed.", (Throwable)e);
                    }
                } else {
                    EmbeddedJmxTransFactory.this.logger.debug("No configuration change detected. Don't reload configuration");
                }
            }
        }
    }
}

