/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.embedded.output;

import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;
import org.jmxtrans.embedded.QueryResult;
import org.jmxtrans.embedded.output.AbstractOutputWriter;
import org.jmxtrans.embedded.output.OutputWriter;
import org.jmxtrans.embedded.util.net.HostAndPort;
import org.jmxtrans.embedded.util.net.SocketWriter;
import org.jmxtrans.embedded.util.pool.SocketWriterPoolFactory;
import org.jmxtrans.embedded.util.pool.UDPSocketWriterPoolFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphiteWriter
extends AbstractOutputWriter
implements OutputWriter {
    public static final int DEFAULT_GRAPHITE_SERVER_PORT = 2003;
    private static final String PROTOCOL_TCP = "TCP";
    private static final String PROTOCOL_UDP = "UDP";
    public static final String DEFAULT_NAME_PREFIX = "servers.#hostname#.";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String metricPathPrefix;
    private HostAndPort graphiteServerHostAndPort;
    private GenericKeyedObjectPool<HostAndPort, SocketWriter> socketWriterPool;

    @Override
    public void start() {
        int port = this.getIntSetting("port", 2003);
        String host = this.getStringSetting("host");
        this.graphiteServerHostAndPort = new HostAndPort(host, port);
        this.logger.info("Start Graphite writer connected to '{}'...", (Object)this.graphiteServerHostAndPort);
        this.metricPathPrefix = this.getStringSetting("namePrefix", DEFAULT_NAME_PREFIX);
        this.metricPathPrefix = this.getStrategy().resolveExpression(this.metricPathPrefix);
        if (!this.metricPathPrefix.isEmpty() && !this.metricPathPrefix.endsWith(".")) {
            this.metricPathPrefix = this.metricPathPrefix + ".";
        }
        GenericKeyedObjectPoolConfig config = new GenericKeyedObjectPoolConfig();
        config.setTestOnBorrow(this.getBooleanSetting("pool.testOnBorrow", true));
        config.setTestWhileIdle(this.getBooleanSetting("pool.testWhileIdle", true));
        config.setMaxTotal(this.getIntSetting("pool.maxActive", -1));
        config.setMaxIdlePerKey(this.getIntSetting("pool.maxIdle", -1));
        config.setMinEvictableIdleTimeMillis(this.getLongSetting("pool.minEvictableIdleTimeMillis", TimeUnit.MINUTES.toMillis(5L)));
        config.setTimeBetweenEvictionRunsMillis(this.getLongSetting("pool.timeBetweenEvictionRunsMillis", TimeUnit.MINUTES.toMillis(5L)));
        config.setJmxNameBase("org.jmxtrans.embedded:type=GenericKeyedObjectPool,writer=GraphiteWriter,name=");
        config.setJmxNamePrefix(this.graphiteServerHostAndPort.getHost() + "_" + this.graphiteServerHostAndPort.getPort());
        int socketConnectTimeoutInMillis = this.getIntSetting("graphite.socketConnectTimeoutInMillis", 500);
        String protocol = this.getStringSetting("protocol", null);
        if (protocol != null && protocol.equalsIgnoreCase(PROTOCOL_UDP)) {
            this.socketWriterPool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)new UDPSocketWriterPoolFactory(StandardCharsets.UTF_8), config);
        } else {
            if (protocol == null) {
                this.logger.info("Protocol unspecified, default protocol '{}' will be used.", (Object)PROTOCOL_TCP);
            } else if (!PROTOCOL_TCP.equalsIgnoreCase(protocol)) {
                this.logger.warn("Unknown protocol specified '{}', default protocol '{}' will be used instead.", (Object)protocol, (Object)PROTOCOL_TCP);
            }
            this.socketWriterPool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)new SocketWriterPoolFactory(StandardCharsets.UTF_8, socketConnectTimeoutInMillis), config);
        }
        if (this.isEnabled()) {
            try {
                SocketWriter socketWriter = (SocketWriter)this.socketWriterPool.borrowObject((Object)this.graphiteServerHostAndPort);
                this.socketWriterPool.returnObject((Object)this.graphiteServerHostAndPort, (Object)socketWriter);
            }
            catch (Exception e) {
                this.logger.warn("Test Connection: FAILURE to connect to Graphite server '{}'", (Object)this.graphiteServerHostAndPort, (Object)e);
            }
        }
    }

    @Override
    public void write(Iterable<QueryResult> results) {
        block5: {
            this.logger.debug("Export to '{}' results {}", (Object)this.graphiteServerHostAndPort, results);
            SocketWriter socketWriter = null;
            try {
                socketWriter = (SocketWriter)this.socketWriterPool.borrowObject((Object)this.graphiteServerHostAndPort);
                for (QueryResult result : results) {
                    String msg = this.metricPathPrefix + result.getName() + " " + result.getValue() + " " + result.getEpoch(TimeUnit.SECONDS) + "\n";
                    this.logger.debug("Export '{}'", (Object)msg);
                    socketWriter.write(msg);
                }
                socketWriter.flush();
                this.socketWriterPool.returnObject((Object)this.graphiteServerHostAndPort, (Object)socketWriter);
            }
            catch (Exception e) {
                this.logger.warn("Failure to send result to graphite server '{}' with {}", new Object[]{this.graphiteServerHostAndPort, socketWriter, e});
                if (socketWriter == null) break block5;
                try {
                    this.socketWriterPool.invalidateObject((Object)this.graphiteServerHostAndPort, (Object)socketWriter);
                }
                catch (Exception e2) {
                    this.logger.warn("Exception invalidating socketWriter connected to graphite server '{}': {}", new Object[]{this.graphiteServerHostAndPort, socketWriter, e2});
                }
            }
        }
    }

    @Override
    public void stop() throws Exception {
        this.logger.info("Stop GraphiteWriter connected to '{}' ...", (Object)this.graphiteServerHostAndPort);
        super.stop();
        this.socketWriterPool.close();
    }
}

