/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.embedded.output;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.jmxtrans.embedded.QueryResult;
import org.jmxtrans.embedded.output.AbstractOutputWriter;
import org.jmxtrans.embedded.output.OutputWriter;
import org.jmxtrans.embedded.util.CachingReference;
import org.jmxtrans.embedded.util.StringUtils2;

public class StatsDWriter
extends AbstractOutputWriter
implements OutputWriter {
    public static final String SETTING_BUFFER_SIZE = "bufferSize";
    private static final int SETTING_DEFAULT_BUFFER_SIZE = 1024;
    public static final String DEFAULT_NAME_PREFIX = "servers.#escaped_hostname#.";
    private ByteBuffer sendBuffer;
    private CachingReference<InetSocketAddress> addressReference;
    private DatagramChannel channel;
    private String metricPathPrefix;

    @Override
    public synchronized void start() {
        final String host = this.getStringSetting("host");
        final Integer port = this.getIntSetting("port");
        this.metricPathPrefix = this.getStringSetting("namePrefix", DEFAULT_NAME_PREFIX);
        this.metricPathPrefix = this.getStrategy().resolveExpression(this.metricPathPrefix);
        if (!this.metricPathPrefix.isEmpty() && !this.metricPathPrefix.endsWith(".")) {
            this.metricPathPrefix = this.metricPathPrefix + ".";
        }
        int bufferSize = this.getIntSetting(SETTING_BUFFER_SIZE, 1024);
        this.sendBuffer = ByteBuffer.allocate(bufferSize);
        this.addressReference = new CachingReference<InetSocketAddress>(30L, TimeUnit.SECONDS){

            @Override
            @Nonnull
            protected InetSocketAddress newObject() {
                return new InetSocketAddress(host, (int)port);
            }
        };
        try {
            this.channel = DatagramChannel.open();
        }
        catch (IOException e) {
            throw new RuntimeException("Exception opening datagram channel", e);
        }
        this.logger.info("Started {}", (Object)this);
    }

    @Override
    public void stop() throws Exception {
        super.stop();
        this.channel.close();
    }

    @Override
    public synchronized void write(Iterable<QueryResult> results) {
        this.logger.debug("Export to {} results {}", (Object)this.addressReference.get(), results);
        for (QueryResult result : results) {
            String stat = this.metricPathPrefix + result.getName() + ":" + result.getValue() + "|" + this.getStatsdMetricType(result) + "\n";
            this.logger.debug("Export '{}'", (Object)stat);
            byte[] data = stat.getBytes(StandardCharsets.UTF_8);
            if (this.sendBuffer.remaining() < data.length + 1) {
                this.flush();
            }
            if (this.sendBuffer.remaining() < data.length + 1) {
                this.logger.warn("Given data too big (" + data.length + "bytes) for the buffer size (" + this.sendBuffer.remaining() + "bytes), skip it: " + StringUtils2.abbreviate(stat, 20));
                continue;
            }
            this.sendBuffer.put(data);
        }
        this.flush();
    }

    public synchronized void flush() {
        InetSocketAddress address = this.addressReference.get();
        try {
            if (this.sendBuffer.position() == 0) {
                return;
            }
            int sizeOfBuffer = this.sendBuffer.position();
            this.sendBuffer.flip();
            int nbSentBytes = this.channel.send(this.sendBuffer, address);
            this.sendBuffer.limit(this.sendBuffer.capacity());
            this.sendBuffer.rewind();
            if (sizeOfBuffer != nbSentBytes) {
                this.logger.warn("Could not send entirely stat {} to host {}:{}. Only sent {} bytes out of {} bytes", new Object[]{this.sendBuffer, address.getHostName(), address.getPort(), nbSentBytes, sizeOfBuffer});
            }
        }
        catch (IOException e) {
            this.addressReference.purge();
            this.logger.warn("Could not send stat {} to host {}:{}", new Object[]{this.sendBuffer, address.getHostName(), address.getPort(), e});
        }
    }

    protected char getStatsdMetricType(@Nonnull QueryResult result) {
        int statsBucketType;
        String metricType = result.getType();
        if (metricType == null || metricType.equalsIgnoreCase("counter")) {
            statsBucketType = 99;
        } else if (metricType.equalsIgnoreCase("gauge")) {
            statsBucketType = 103;
        } else if (metricType.equalsIgnoreCase("set")) {
            statsBucketType = 115;
        } else if (metricType.length() == 1) {
            statsBucketType = metricType.charAt(0);
        } else {
            this.logger.warn("Unknown metric type for {}, default to 'c'", (Object)result);
            statsBucketType = 99;
        }
        return (char)statsBucketType;
    }

    @Override
    public String toString() {
        return "StatsDOutputWriter{addressReference=" + this.addressReference + ", metricPathPrefix='" + this.metricPathPrefix + '\'' + ", sendBuffer=" + this.sendBuffer + '}';
    }
}

