/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.embedded.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;

public abstract class CachingReference<E> {
    private final ReadWriteLock rwl = new ReentrantReadWriteLock();
    private long lastCreationInNanos;
    private long timeToLiveInNanos;
    private E object;

    public CachingReference(long timeToLiveInNanos) {
        this.timeToLiveInNanos = timeToLiveInNanos;
    }

    public CachingReference(long timeToLive, TimeUnit timeToLiveUnit) {
        this(TimeUnit.NANOSECONDS.convert(timeToLive, timeToLiveUnit));
    }

    @Nullable
    protected abstract E newObject();

    @Nullable
    public E get() {
        this.rwl.readLock().lock();
        try {
            if (this.object == null || System.nanoTime() - this.lastCreationInNanos > this.timeToLiveInNanos) {
                this.rwl.readLock().unlock();
                this.rwl.writeLock().lock();
                try {
                    if (this.object == null || System.nanoTime() - this.lastCreationInNanos > this.timeToLiveInNanos) {
                        this.object = this.newObject();
                        this.lastCreationInNanos = System.nanoTime();
                    }
                }
                finally {
                    this.rwl.readLock().lock();
                    this.rwl.writeLock().unlock();
                }
            }
            E e = this.object;
            return e;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    public void purge() {
        this.rwl.writeLock().lock();
        try {
            this.object = null;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    public String toString() {
        return "CachingReference[" + this.object + "]";
    }
}

