/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.embedded.config;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.jmxtrans.embedded.EmbeddedJmxTrans;
import org.jmxtrans.embedded.EmbeddedJmxTransException;
import org.jmxtrans.embedded.Query;
import org.jmxtrans.embedded.QueryAttribute;
import org.jmxtrans.embedded.output.OutputWriter;
import org.jmxtrans.embedded.util.Preconditions;
import org.jmxtrans.embedded.util.json.PlaceholderEnabledJsonNodeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationParser {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ObjectMapper mapper = new ObjectMapper();

    public ConfigurationParser() {
        this.mapper.setNodeFactory((JsonNodeFactory)new PlaceholderEnabledJsonNodeFactory());
    }

    public EmbeddedJmxTrans newEmbeddedJmxTrans(String ... configurationUrls) throws EmbeddedJmxTransException {
        EmbeddedJmxTrans embeddedJmxTrans = new EmbeddedJmxTrans();
        for (String configurationUrl : configurationUrls) {
            this.mergeEmbeddedJmxTransConfiguration(configurationUrl, embeddedJmxTrans);
        }
        return embeddedJmxTrans;
    }

    public EmbeddedJmxTrans newEmbeddedJmxTrans(@Nonnull List<String> configurationUrls) throws EmbeddedJmxTransException {
        EmbeddedJmxTrans embeddedJmxTrans = new EmbeddedJmxTrans();
        for (String configurationUrl : configurationUrls) {
            this.mergeEmbeddedJmxTransConfiguration(configurationUrl, embeddedJmxTrans);
        }
        return embeddedJmxTrans;
    }

    @Nonnull
    public EmbeddedJmxTrans newEmbeddedJmxTrans(@Nonnull String configurationUrl) throws EmbeddedJmxTransException {
        EmbeddedJmxTrans embeddedJmxTrans = new EmbeddedJmxTrans();
        this.mergeEmbeddedJmxTransConfiguration(configurationUrl, embeddedJmxTrans);
        return embeddedJmxTrans;
    }

    protected void mergeEmbeddedJmxTransConfiguration(@Nonnull String configurationUrl, @Nonnull EmbeddedJmxTrans embeddedJmxTrans) throws EmbeddedJmxTransException {
        try {
            if (configurationUrl.startsWith("classpath:")) {
                String path = configurationUrl.substring("classpath:".length());
                InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
                Preconditions.checkNotNull(in, "No file found for '" + configurationUrl + "'");
                this.mergeEmbeddedJmxTransConfiguration(in, embeddedJmxTrans);
            } else {
                this.mergeEmbeddedJmxTransConfiguration(new URL(configurationUrl), embeddedJmxTrans);
            }
        }
        catch (JsonProcessingException e) {
            throw new EmbeddedJmxTransException("Exception loading configuration'" + configurationUrl + "': " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new EmbeddedJmxTransException("Exception loading configuration'" + configurationUrl + "'", e);
        }
    }

    @Nonnull
    public EmbeddedJmxTrans newEmbeddedJmxTrans(@Nonnull InputStream configuration) throws IOException {
        EmbeddedJmxTrans embeddedJmxTrans = new EmbeddedJmxTrans();
        this.mergeEmbeddedJmxTransConfiguration(configuration, embeddedJmxTrans);
        return embeddedJmxTrans;
    }

    public void mergeEmbeddedJmxTransConfiguration(@Nonnull InputStream configuration, EmbeddedJmxTrans embeddedJmxTrans) throws IOException {
        JsonNode configurationRootNode = (JsonNode)this.mapper.readValue(configuration, JsonNode.class);
        this.mergeEmbeddedJmxTransConfiguration(configurationRootNode, embeddedJmxTrans);
    }

    public EmbeddedJmxTrans newEmbeddedJmxTrans(@Nonnull URL configurationUrl) throws IOException {
        EmbeddedJmxTrans embeddedJmxTrans = new EmbeddedJmxTrans();
        this.mergeEmbeddedJmxTransConfiguration(configurationUrl, embeddedJmxTrans);
        return embeddedJmxTrans;
    }

    public EmbeddedJmxTrans newEmbeddedJmxTrans(@Nonnull JsonNode configurationRootNode) {
        EmbeddedJmxTrans embeddedJmxTrans = new EmbeddedJmxTrans();
        this.mergeEmbeddedJmxTransConfiguration(configurationRootNode, embeddedJmxTrans);
        return embeddedJmxTrans;
    }

    protected void mergeEmbeddedJmxTransConfiguration(@Nonnull URL configurationUrl, EmbeddedJmxTrans embeddedJmxTrans) throws IOException {
        JsonNode configurationRootNode = (JsonNode)this.mapper.readValue(configurationUrl, JsonNode.class);
        this.mergeEmbeddedJmxTransConfiguration(configurationRootNode, embeddedJmxTrans);
    }

    private void mergeEmbeddedJmxTransConfiguration(@Nonnull JsonNode configurationRootNode, @Nonnull EmbeddedJmxTrans embeddedJmxTrans) {
        JsonNode numExportThreadsNode;
        JsonNode exportIntervalInSecondsNode;
        JsonNode numQueryThreadsNode;
        JsonNode exportBatchSizeNode;
        for (JsonNode queryNode : configurationRootNode.path("queries")) {
            JsonNode attributesNode;
            String objectName = queryNode.path("objectName").asText();
            Query query = new Query(objectName);
            embeddedJmxTrans.addQuery(query);
            JsonNode resultAliasNode = queryNode.path("resultAlias");
            if (!resultAliasNode.isMissingNode()) {
                if (resultAliasNode.isValueNode()) {
                    query.setResultAlias(resultAliasNode.asText());
                } else {
                    this.logger.warn("Ignore invalid node {}", (Object)resultAliasNode);
                }
            }
            if (!(attributesNode = queryNode.path("attributes")).isMissingNode()) {
                if (attributesNode.isArray()) {
                    Iterator itAttributeNode = attributesNode.elements();
                    while (itAttributeNode.hasNext()) {
                        JsonNode attributeNode = (JsonNode)itAttributeNode.next();
                        this.parseQueryAttributeNode(query, attributeNode);
                    }
                } else {
                    this.logger.warn("Ignore invalid node {}", (Object)resultAliasNode);
                }
            }
            JsonNode attributeNode = queryNode.path("attribute");
            this.parseQueryAttributeNode(query, attributeNode);
            List<OutputWriter> outputWriters = this.parseOutputWritersNode(queryNode);
            query.getOutputWriters().addAll(outputWriters);
        }
        List<OutputWriter> outputWriters = this.parseOutputWritersNode(configurationRootNode);
        embeddedJmxTrans.getOutputWriters().addAll(outputWriters);
        JsonNode queryIntervalInSecondsNode = configurationRootNode.path("queryIntervalInSeconds");
        if (!queryIntervalInSecondsNode.isMissingNode()) {
            embeddedJmxTrans.setQueryIntervalInSeconds(queryIntervalInSecondsNode.asInt());
        }
        if (!(exportBatchSizeNode = configurationRootNode.path("exportBatchSize")).isMissingNode()) {
            embeddedJmxTrans.setExportBatchSize(exportBatchSizeNode.asInt());
        }
        if (!(numQueryThreadsNode = configurationRootNode.path("numQueryThreads")).isMissingNode()) {
            embeddedJmxTrans.setNumQueryThreads(numQueryThreadsNode.asInt());
        }
        if (!(exportIntervalInSecondsNode = configurationRootNode.path("exportIntervalInSeconds")).isMissingNode()) {
            embeddedJmxTrans.setExportIntervalInSeconds(exportIntervalInSecondsNode.asInt());
        }
        if (!(numExportThreadsNode = configurationRootNode.path("numExportThreads")).isMissingNode()) {
            embeddedJmxTrans.setNumExportThreads(numExportThreadsNode.asInt());
        }
        this.logger.info("Loaded {}", (Object)embeddedJmxTrans);
    }

    private List<OutputWriter> parseOutputWritersNode(@Nonnull JsonNode outputWritersParentNode) {
        JsonNode outputWritersNode = outputWritersParentNode.path("outputWriters");
        ArrayList<OutputWriter> outputWriters = new ArrayList<OutputWriter>();
        if (!outputWritersNode.isMissingNode()) {
            if (outputWritersNode.isArray()) {
                for (JsonNode outputWriterNode : outputWritersNode) {
                    try {
                        JsonNode settingsNode;
                        String className = outputWriterNode.path("@class").asText();
                        OutputWriter outputWriter = (OutputWriter)Class.forName(className).newInstance();
                        JsonNode deprecatedEnabledNode = outputWriterNode.path("enabled");
                        if (!deprecatedEnabledNode.isMissingNode()) {
                            this.logger.warn("OutputWriter {}, deprecated usage of attribute 'enabled', settings{ \"enabled\":... } should be used instead");
                            outputWriter.setEnabled(deprecatedEnabledNode.asBoolean());
                        }
                        if (!(settingsNode = outputWriterNode.path("settings")).isMissingNode()) {
                            if (settingsNode.isObject()) {
                                ObjectMapper mapper = new ObjectMapper();
                                Map settings = (Map)mapper.treeToValue((TreeNode)settingsNode, Map.class);
                                outputWriter.setSettings(settings);
                                if (settings.containsKey("enabled")) {
                                    outputWriter.setEnabled(Boolean.valueOf(String.valueOf(settings.get("enabled"))));
                                }
                            } else {
                                this.logger.warn("Ignore invalid node {}", (Object)outputWriterNode);
                            }
                        }
                        outputWriters.add(outputWriter);
                    }
                    catch (Exception e) {
                        throw new EmbeddedJmxTransException("Exception converting settings " + outputWritersNode, e);
                    }
                }
            } else {
                this.logger.warn("Ignore invalid node {}", (Object)outputWritersNode);
            }
        }
        return outputWriters;
    }

    protected void parseQueryAttributeNode(@Nonnull Query query, @Nonnull JsonNode attributeNode) {
        if (!attributeNode.isMissingNode()) {
            if (attributeNode.isValueNode()) {
                query.addAttribute(attributeNode.asText());
            } else if (attributeNode.isObject()) {
                String resultAlias;
                JsonNode keyNode;
                ArrayList<String> keys = null;
                JsonNode keysNode = attributeNode.path("keys");
                if (!keysNode.isMissingNode()) {
                    if (keysNode.isArray()) {
                        if (keys == null) {
                            keys = new ArrayList<String>();
                        }
                        Iterator itAttributeNode = keysNode.elements();
                        while (itAttributeNode.hasNext()) {
                            JsonNode keyNode2 = (JsonNode)itAttributeNode.next();
                            if (keyNode2.isValueNode()) {
                                keys.add(keyNode2.asText());
                                continue;
                            }
                            this.logger.warn("Ignore invalid node {}", (Object)keyNode2);
                        }
                    } else {
                        this.logger.warn("Ignore invalid node {}", (Object)keysNode);
                    }
                }
                if (!(keyNode = attributeNode.path("key")).isMissingNode()) {
                    if (keyNode.isValueNode()) {
                        if (keys == null) {
                            keys = new ArrayList();
                        }
                        keys.add(keyNode.asText());
                    } else {
                        this.logger.warn("Ignore invalid node {}", (Object)keyNode);
                    }
                }
                String name = attributeNode.path("name").asText();
                JsonNode resultAliasNode = attributeNode.path("resultAlias");
                String string = resultAlias = resultAliasNode.isMissingNode() ? null : resultAliasNode.asText();
                if (keys == null) {
                    query.addAttribute(new QueryAttribute(name, resultAlias));
                } else {
                    query.addAttribute(new QueryAttribute(name, resultAlias, keys));
                }
            } else {
                this.logger.warn("Ignore invalid node {}", (Object)attributeNode);
            }
        }
    }
}

