/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.embedded.spring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jmxtrans.embedded.EmbeddedJmxTrans;
import org.jmxtrans.embedded.EmbeddedJmxTransException;
import org.jmxtrans.embedded.config.ConfigurationParser;
import org.jmxtrans.embedded.spring.SpringEmbeddedJmxTrans;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StringUtils;

public class EmbeddedJmxTransFactory
implements FactoryBean<SpringEmbeddedJmxTrans>,
BeanNameAware {
    private static final String DEFAULT_CONFIGURATION_URL = "classpath:jmxtrans.json, classpath:org/jmxtrans/embedded/config/jmxtrans-internals.json";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<String> configurationUrls;
    private SpringEmbeddedJmxTrans embeddedJmxTrans;
    private ResourceLoader resourceLoader;
    private boolean ignoreConfigurationNotFound = false;
    private String beanName = "jmxtrans";

    @Autowired
    public EmbeddedJmxTransFactory(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public SpringEmbeddedJmxTrans getObject() throws Exception {
        this.logger.info("Load JmxTrans with configuration '{}'", this.configurationUrls);
        if (this.embeddedJmxTrans == null) {
            if (this.configurationUrls == null) {
                this.configurationUrls = Collections.singletonList(DEFAULT_CONFIGURATION_URL);
            }
            ConfigurationParser parser = new ConfigurationParser();
            SpringEmbeddedJmxTrans newJmxTrans = new SpringEmbeddedJmxTrans();
            newJmxTrans.setObjectName("org.jmxtrans.embedded:type=EmbeddedJmxTrans,name=" + this.beanName);
            for (String delimitedConfigurationUrl : this.configurationUrls) {
                String[] tokens = StringUtils.commaDelimitedListToStringArray((String)delimitedConfigurationUrl);
                for (String configurationUrl : tokens = StringUtils.trimArrayElements((String[])tokens)) {
                    configurationUrl = configurationUrl.trim();
                    this.logger.debug("Load configuration {}", (Object)configurationUrl);
                    Resource configuration = this.resourceLoader.getResource(configurationUrl);
                    if (configuration.exists()) {
                        try {
                            parser.mergeEmbeddedJmxTransConfiguration(configuration.getInputStream(), (EmbeddedJmxTrans)newJmxTrans);
                            continue;
                        }
                        catch (Exception e) {
                            throw new EmbeddedJmxTransException("Exception loading configuration " + configuration, e);
                        }
                    }
                    if (this.ignoreConfigurationNotFound) {
                        this.logger.debug("Ignore missing configuration file {}", (Object)configuration);
                        continue;
                    }
                    throw new EmbeddedJmxTransException("Configuration file " + configuration + " not found");
                }
            }
            this.embeddedJmxTrans = newJmxTrans;
            this.logger.info("Created EmbeddedJmxTrans with configuration {})", this.configurationUrls);
            this.embeddedJmxTrans.start();
        }
        return this.embeddedJmxTrans;
    }

    public Class<?> getObjectType() {
        return EmbeddedJmxTrans.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setConfigurationUrl(String configurationUrl) {
        if (this.configurationUrls == null) {
            this.configurationUrls = new ArrayList<String>();
        }
        this.configurationUrls.add(configurationUrl);
    }

    public void setConfigurationUrls(List<String> configurationUrls) {
        if (this.configurationUrls == null) {
            this.configurationUrls = new ArrayList<String>();
        }
        this.configurationUrls.addAll(configurationUrls);
    }

    public void setIgnoreConfigurationNotFound(boolean ignoreConfigurationNotFound) {
        this.ignoreConfigurationNotFound = ignoreConfigurationNotFound;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }
}

