/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.embedded;

import java.sql.Timestamp;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jmxtrans.embedded.util.Preconditions;

public class QueryResult {
    @Nonnull
    private final String name;
    private final long epochInMillis;
    @Nullable
    private final Object value;
    @Nullable
    private final String type;

    public QueryResult(@Nonnull String name, @Nullable Object value, long epochInMillis) {
        this(name, null, value, epochInMillis);
    }

    public QueryResult(@Nonnull String name, @Nullable String type, @Nullable Object value, long epochInMillis) {
        this.name = Preconditions.checkNotEmpty(name);
        this.value = value;
        this.epochInMillis = epochInMillis;
        this.type = type;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    public long getEpochInMillis() {
        return this.epochInMillis;
    }

    public long getEpoch(TimeUnit timeUnit) {
        return timeUnit.convert(this.epochInMillis, TimeUnit.MILLISECONDS);
    }

    @Nullable
    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return "QueryResult{ epoch=" + new Timestamp(this.epochInMillis) + ", name='" + this.name + '\'' + ", value=" + this.value + '}';
    }
}

