/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.embedded.output;

import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jmxtrans.embedded.EmbeddedJmxTransException;
import org.jmxtrans.embedded.QueryResult;
import org.jmxtrans.embedded.output.AbstractOutputWriter;
import org.jmxtrans.embedded.output.OutputWriter;
import org.jmxtrans.embedded.util.io.IoUtils2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LibratoWriter
extends AbstractOutputWriter
implements OutputWriter {
    public static final String METRIC_TYPE_GAUGE = "gauge";
    public static final String METRIC_TYPE_COUNTER = "counter";
    public static final String DEFAULT_LIBRATOR_URL = "https://metrics-api.librato.com/v1/metrics";
    public static final String SETTING_LIBRATO_API_TIMEOUT_IN_MILLIS = "libratoApiTimeoutInMillis";
    public static final int DEFAULT_LIBRATO_API_TIMEOUT_IN_MILLIS = 1000;
    public static final String SETTING_SOURCE = "source";
    public static final String DEFAULT_SOURCE = "#hostname#";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AtomicInteger exceptionCounter = new AtomicInteger();
    private JsonFactory jsonFactory = new JsonFactory();
    private URL url;
    private int libratoApiTimeoutInMillis = 1000;
    private String user;
    private String token;
    private String basicAuthentication;
    @Nullable
    private Proxy proxy;
    @Nullable
    private String source;

    @Override
    public void start() {
        try {
            this.url = new URL(this.getStringSetting("url", DEFAULT_LIBRATOR_URL));
            this.user = this.getStringSetting("username");
            this.token = this.getStringSetting("token");
            this.basicAuthentication = Base64Variants.getDefaultVariant().encode((this.user + ":" + this.token).getBytes(Charset.forName("US-ASCII")));
            if (this.getStringSetting("proxyHost", null) != null && !this.getStringSetting("proxyHost").isEmpty()) {
                this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.getStringSetting("proxyHost"), this.getIntSetting("proxyPort")));
            }
            this.libratoApiTimeoutInMillis = this.getIntSetting(SETTING_LIBRATO_API_TIMEOUT_IN_MILLIS, 1000);
            this.source = this.getStringSetting(SETTING_SOURCE, DEFAULT_SOURCE);
            this.source = this.getStrategy().resolveExpression(this.source);
            this.logger.info("Start Librato writer connected to '{}', proxy {} with user '{}' ...", new Object[]{this.url, this.proxy, this.user});
        }
        catch (MalformedURLException e) {
            throw new EmbeddedJmxTransException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Iterable<QueryResult> results) {
        this.logger.debug("Export to '{}', proxy {} metrics {}", new Object[]{this.url, this.proxy, results});
        ArrayList<QueryResult> counters = new ArrayList<QueryResult>();
        ArrayList<QueryResult> gauges = new ArrayList<QueryResult>();
        for (QueryResult result : results) {
            if (METRIC_TYPE_GAUGE.equals(result.getType())) {
                gauges.add(result);
                continue;
            }
            if (METRIC_TYPE_COUNTER.equals(result.getType())) {
                counters.add(result);
                continue;
            }
            if (null == result.getType()) {
                this.logger.info("Unspecified type for result {}, export it as counter");
                counters.add(result);
                continue;
            }
            this.logger.info("Unsupported metric type '{}' for result {}, export it as counter", (Object)result.getType(), (Object)result);
            counters.add(result);
        }
        URLConnection urlConnection = null;
        try {
            urlConnection = this.proxy == null ? (HttpURLConnection)this.url.openConnection() : (HttpURLConnection)this.url.openConnection(this.proxy);
            ((HttpURLConnection)urlConnection).setRequestMethod("POST");
            urlConnection.setDoInput(true);
            urlConnection.setDoOutput(true);
            urlConnection.setReadTimeout(this.libratoApiTimeoutInMillis);
            urlConnection.setRequestProperty("content-type", "application/json; charset=utf-8");
            urlConnection.setRequestProperty("Authorization", "Basic " + this.basicAuthentication);
            this.serialize(counters, gauges, urlConnection.getOutputStream());
            int responseCode = ((HttpURLConnection)urlConnection).getResponseCode();
            if (responseCode != 200) {
                this.exceptionCounter.incrementAndGet();
                this.logger.warn("Failure {}:'{}' to send result to Librato server '{}' with proxy {}, user {}", new Object[]{responseCode, ((HttpURLConnection)urlConnection).getResponseMessage(), this.url, this.proxy, this.user});
            }
            if (this.logger.isTraceEnabled()) {
                IoUtils2.copy(urlConnection.getInputStream(), System.out);
            }
        }
        catch (Exception e) {
            this.exceptionCounter.incrementAndGet();
            this.logger.warn("Failure to send result to Librato server '{}' with proxy {}, user {}", new Object[]{this.url, this.proxy, this.user, e});
        }
        finally {
            if (urlConnection != null) {
                try {
                    InputStream in = urlConnection.getInputStream();
                    IoUtils2.copy(in, IoUtils2.nullOutputStream());
                    IoUtils2.closeQuietly(in);
                    InputStream err = ((HttpURLConnection)urlConnection).getErrorStream();
                    if (err != null) {
                        IoUtils2.copy(err, IoUtils2.nullOutputStream());
                        IoUtils2.closeQuietly(err);
                    }
                }
                catch (IOException e) {
                    this.logger.warn("Exception flushing http connection", (Throwable)e);
                }
            }
        }
    }

    public void serialize(@Nonnull Iterable<QueryResult> counters, @Nonnull Iterable<QueryResult> gauges, @Nonnull OutputStream out) throws IOException {
        JsonGenerator g = this.jsonFactory.createGenerator(out, JsonEncoding.UTF8);
        g.writeStartObject();
        g.writeArrayFieldStart("counters");
        for (QueryResult counter : counters) {
            g.writeStartObject();
            g.writeStringField("name", counter.getName());
            if (this.source != null && !this.source.isEmpty()) {
                g.writeStringField(SETTING_SOURCE, this.source);
            }
            g.writeNumberField("measure_time", counter.getEpoch(TimeUnit.SECONDS));
            if (counter.getValue() instanceof Integer) {
                g.writeNumberField("value", ((Integer)counter.getValue()).intValue());
            } else if (counter.getValue() instanceof Long) {
                g.writeNumberField("value", ((Long)counter.getValue()).longValue());
            } else if (counter.getValue() instanceof Float) {
                g.writeNumberField("value", ((Float)counter.getValue()).floatValue());
            } else if (counter.getValue() instanceof Double) {
                g.writeNumberField("value", ((Double)counter.getValue()).doubleValue());
            }
            g.writeEndObject();
        }
        g.writeEndArray();
        g.writeArrayFieldStart("gauges");
        for (QueryResult gauge : gauges) {
            g.writeStartObject();
            g.writeStringField("name", gauge.getName());
            if (this.source != null && !this.source.isEmpty()) {
                g.writeStringField(SETTING_SOURCE, this.source);
            }
            g.writeNumberField("measure_time", gauge.getEpoch(TimeUnit.SECONDS));
            if (gauge.getValue() instanceof Integer) {
                g.writeNumberField("value", ((Integer)gauge.getValue()).intValue());
            } else if (gauge.getValue() instanceof Long) {
                g.writeNumberField("value", ((Long)gauge.getValue()).longValue());
            } else if (gauge.getValue() instanceof Float) {
                g.writeNumberField("value", ((Float)gauge.getValue()).floatValue());
            } else if (gauge.getValue() instanceof Double) {
                g.writeNumberField("value", ((Double)gauge.getValue()).doubleValue());
            }
            g.writeEndObject();
        }
        g.writeEndArray();
        g.writeEndObject();
        g.flush();
        g.close();
    }

    public int getExceptionCounter() {
        return this.exceptionCounter.get();
    }
}

