/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.embedded.output;

import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectName;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.jmxtrans.embedded.EmbeddedJmxTransException;
import org.jmxtrans.embedded.QueryResult;
import org.jmxtrans.embedded.output.AbstractOutputWriter;
import org.jmxtrans.embedded.output.OutputWriter;
import org.jmxtrans.embedded.util.jmx.JmxUtils2;
import org.jmxtrans.embedded.util.net.SocketOutputStream;
import org.jmxtrans.embedded.util.pool.ManagedGenericKeyedObjectPool;
import org.jmxtrans.embedded.util.pool.SocketOutputStreamPoolFactory;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.modules.cPickle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphitePickleWriter
extends AbstractOutputWriter
implements OutputWriter {
    public static final int DEFAULT_GRAPHITE_SERVER_PORT = 2004;
    public static final String DEFAULT_NAME_PREFIX = "servers.#hostname#.";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String metricPathPrefix;
    private InetSocketAddress graphiteServerSocketAddress;
    private ManagedGenericKeyedObjectPool<InetSocketAddress, SocketOutputStream> socketOutputStreamPool;
    private ObjectName socketPoolObjectName;

    @Override
    public void start() {
        int port = this.getIntSetting("port", 2004);
        String host = this.getStringSetting("host");
        this.graphiteServerSocketAddress = new InetSocketAddress(host, port);
        this.logger.info("Start Graphite Pickle writer connected to '{}'...", (Object)this.graphiteServerSocketAddress);
        this.metricPathPrefix = this.getStringSetting("namePrefix", DEFAULT_NAME_PREFIX);
        this.metricPathPrefix = this.getStrategy().resolveExpression(this.metricPathPrefix);
        if (!this.metricPathPrefix.isEmpty() && !this.metricPathPrefix.endsWith(".")) {
            this.metricPathPrefix = this.metricPathPrefix + ".";
        }
        GenericKeyedObjectPool.Config config = new GenericKeyedObjectPool.Config();
        config.testOnBorrow = this.getBooleanSetting("pool.testOnBorrow", true);
        config.testWhileIdle = this.getBooleanSetting("pool.testWhileIdle", true);
        config.maxActive = this.getIntSetting("pool.maxActive", -1);
        config.maxIdle = this.getIntSetting("pool.maxIdle", -1);
        config.minEvictableIdleTimeMillis = this.getLongSetting("pool.minEvictableIdleTimeMillis", TimeUnit.MINUTES.toMillis(5L));
        config.timeBetweenEvictionRunsMillis = this.getLongSetting("pool.timeBetweenEvictionRunsMillis", TimeUnit.MINUTES.toMillis(5L));
        this.socketOutputStreamPool = new ManagedGenericKeyedObjectPool<InetSocketAddress, SocketOutputStream>(new SocketOutputStreamPoolFactory(), config);
        this.socketPoolObjectName = JmxUtils2.registerObject(this.socketOutputStreamPool, "org.jmxtrans.embedded:Type=SocketPool,Host=" + host + ",Port=" + port + ",Name=GraphiteSocketPool@" + System.identityHashCode(this), ManagementFactory.getPlatformMBeanServer());
        if (this.isEnabled()) {
            try {
                SocketOutputStream socketOutputStream = (SocketOutputStream)this.socketOutputStreamPool.borrowObject(this.graphiteServerSocketAddress);
                this.socketOutputStreamPool.returnObject(this.graphiteServerSocketAddress, socketOutputStream);
            }
            catch (Exception e) {
                this.logger.warn("Test Connection: FAILURE to connect to Graphite server '{}'", (Object)this.graphiteServerSocketAddress, (Object)e);
            }
        }
        try {
            Class.forName("org.python.modules.cPickle");
        }
        catch (ClassNotFoundException e) {
            throw new EmbeddedJmxTransException("jython librarie is required by the " + this.getClass().getSimpleName() + " but is not found in the classpath. Please add org.python:jython:2.5.3+ to the classpath.");
        }
    }

    @Override
    public void write(Iterable<QueryResult> results) {
        block5: {
            this.logger.debug("Export to '{}' results {}", (Object)this.graphiteServerSocketAddress, results);
            SocketOutputStream socketOutputStream = null;
            try {
                socketOutputStream = (SocketOutputStream)this.socketOutputStreamPool.borrowObject(this.graphiteServerSocketAddress);
                PyList list = new PyList();
                for (QueryResult result : results) {
                    String metricName = this.metricPathPrefix + result.getName();
                    int time = (int)result.getEpoch(TimeUnit.SECONDS);
                    Object pyValue = result.getValue() instanceof Integer ? new PyInteger(((Integer)result.getValue()).intValue()) : (result.getValue() instanceof Long ? new PyLong(((Long)result.getValue()).longValue()) : (result.getValue() instanceof Float ? new PyFloat(((Float)result.getValue()).floatValue()) : (result.getValue() instanceof Double ? new PyFloat(((Double)result.getValue()).doubleValue()) : (result.getValue() instanceof Date ? new PyLong(TimeUnit.SECONDS.convert(((Date)result.getValue()).getTime(), TimeUnit.MILLISECONDS)) : new PyString(result.getValue().toString())))));
                    list.add((Object)new PyTuple(new PyObject[]{new PyString(metricName), new PyTuple(new PyObject[]{new PyInteger(time), pyValue})}));
                    this.logger.debug("Export '{}': ", (Object)metricName, (Object)result);
                }
                PyString payload = cPickle.dumps((PyObject)list);
                byte[] header = ByteBuffer.allocate(4).putInt(payload.__len__()).array();
                socketOutputStream.write(header);
                socketOutputStream.write(payload.toBytes());
                socketOutputStream.flush();
                this.socketOutputStreamPool.returnObject(this.graphiteServerSocketAddress, socketOutputStream);
            }
            catch (Exception e) {
                this.logger.warn("Failure to send result to graphite server '{}' with {}", new Object[]{this.graphiteServerSocketAddress, socketOutputStream, e});
                if (socketOutputStream == null) break block5;
                try {
                    this.socketOutputStreamPool.invalidateObject(this.graphiteServerSocketAddress, socketOutputStream);
                }
                catch (Exception e2) {
                    this.logger.warn("Exception invalidating socketWriter connected to graphite server '{}': {}", new Object[]{this.graphiteServerSocketAddress, socketOutputStream, e2});
                }
            }
        }
    }

    @Override
    public void stop() throws Exception {
        this.logger.info("Stop GraphitePickleWriter connected to '{}' ...", (Object)this.graphiteServerSocketAddress);
        super.stop();
        this.socketOutputStreamPool.close();
        JmxUtils2.unregisterObject(this.socketPoolObjectName, ManagementFactory.getPlatformMBeanServer());
    }
}

