/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.embedded.util.pool;

import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.commons.pool.BaseKeyedPoolableObjectFactory;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.jmxtrans.embedded.util.net.SocketOutputStream;

public class SocketOutputStreamPoolFactory
extends BaseKeyedPoolableObjectFactory<InetSocketAddress, SocketOutputStream>
implements KeyedPoolableObjectFactory<InetSocketAddress, SocketOutputStream> {
    public SocketOutputStream makeObject(InetSocketAddress inetSocketAddress) throws Exception {
        Socket socket = new Socket(inetSocketAddress.getAddress(), inetSocketAddress.getPort());
        socket.setKeepAlive(true);
        return new SocketOutputStream(socket);
    }

    public void destroyObject(InetSocketAddress inetSocketAddress, SocketOutputStream socketOutputStream) throws Exception {
        super.destroyObject((Object)inetSocketAddress, (Object)socketOutputStream);
        socketOutputStream.close();
        socketOutputStream.getSocket().close();
    }

    public boolean validateObject(InetSocketAddress inetSocketAddress, SocketOutputStream socketOutputStream) {
        Socket socket = socketOutputStream.getSocket();
        return socket.isConnected() && socket.isBound() && !socket.isClosed() && !socket.isInputShutdown() && !socket.isOutputShutdown();
    }
}

