/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.embedded.servlet;

import java.lang.management.ManagementFactory;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.jmxtrans.embedded.EmbeddedJmxTrans;
import org.jmxtrans.embedded.EmbeddedJmxTransException;
import org.jmxtrans.embedded.config.ConfigurationParser;
import org.jmxtrans.embedded.util.StringUtils2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedJmxTransLoaderListener
implements ServletContextListener {
    public static final String CONFIG_LOCATION_PARAM = "jmxtrans.config";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private EmbeddedJmxTrans embeddedJmxTrans;
    private ObjectName objectName;
    private MBeanServer mbeanServer;

    public void contextInitialized(ServletContextEvent sce) {
        sce.getServletContext().log("Start embedded-jmxtrans ...");
        this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
        ConfigurationParser configurationParser = new ConfigurationParser();
        String configuration = sce.getServletContext().getInitParameter(CONFIG_LOCATION_PARAM);
        if (configuration == null || configuration.isEmpty()) {
            configuration = "classpath:jmxtrans.json, classpath:org/jmxtrans/embedded/config/jmxtrans-internals.json";
        }
        List<String> configurationUrls = StringUtils2.delimitedStringToList(configuration);
        this.embeddedJmxTrans = configurationParser.newEmbeddedJmxTrans(configurationUrls);
        String on = "org.jmxtrans.embedded:type=EmbeddedJmxTrans,name=jmxtrans,path=" + sce.getServletContext().getContextPath();
        try {
            this.objectName = this.mbeanServer.registerMBean(this.embeddedJmxTrans, new ObjectName(on)).getObjectName();
        }
        catch (Exception e) {
            throw new EmbeddedJmxTransException("Exception registering '" + this.objectName + "'", e);
        }
        try {
            this.embeddedJmxTrans.start();
        }
        catch (Exception e) {
            String message = "Exception starting jmxtrans for application '" + sce.getServletContext().getContextPath() + "'";
            sce.getServletContext().log(message, (Throwable)e);
            throw new EmbeddedJmxTransException(message, e);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        sce.getServletContext().log("Stop embedded-jmxtrans ...");
        try {
            this.mbeanServer.unregisterMBean(this.objectName);
        }
        catch (Exception e) {
            this.logger.error("Silently skip exception unregistering mbean '" + this.objectName + "'");
        }
        try {
            this.embeddedJmxTrans.stop();
        }
        catch (Exception e) {
            throw new EmbeddedJmxTransException("Exception stopping '" + this.objectName + "'", e);
        }
    }
}

